/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack.sequencer;

public class JackEvent {
    public static final int ALL_TRACKS = -1;
    public static final int MIDI_SYSTEM_EVENT = 1;
    public static final int MIDI_EVENT_NOTEON = 2;
    public static final int MIDI_EVENT_NOTEOFF = 3;
    public static final int MIDI_EVENT_PROGRAM_CHANGE = 4;
    public static final int MIDI_EVENT_CONTROL_CHANGE = 5;
    public static final int MIDI_EVENT_PITCH_BEND = 6;
    private long tick;
    private int type;
    private int track;
    private byte[] data;

    public JackEvent(long l, int n, byte[] byArray) {
        this(l, n, -1, byArray);
    }

    public JackEvent(long l, int n, int n2, byte[] byArray) {
        this.tick = l;
        this.type = n;
        this.track = n2;
        this.data = byArray;
    }

    public long getTick() {
        return this.tick;
    }

    public int getType() {
        return this.type;
    }

    public int getTrack() {
        return this.track;
    }

    public byte[] getData() {
        return this.data;
    }

    public static JackEvent systemReset(long l) {
        return new JackEvent(l, 1, -1, null);
    }

    public static JackEvent noteOn(long l, int n, int n2, int n3, int n4) {
        return new JackEvent(l, 2, n, new byte[]{(byte)n2, (byte)n3, (byte)n4});
    }

    public static JackEvent noteOff(long l, int n, int n2, int n3, int n4) {
        return new JackEvent(l, 3, n, new byte[]{(byte)n2, (byte)n3, (byte)n4});
    }

    public static JackEvent controlChange(long l, int n, int n2, int n3, int n4) {
        return new JackEvent(l, 5, n, new byte[]{(byte)n2, (byte)n3, (byte)n4});
    }

    public static JackEvent programChange(long l, int n, int n2, int n3) {
        return new JackEvent(l, 4, n, new byte[]{(byte)n2, (byte)n3});
    }

    public static JackEvent pitchBend(long l, int n, int n2, int n3) {
        return new JackEvent(l, 6, n, new byte[]{(byte)n2, (byte)n3});
    }

    public static JackEvent tempoInUSQ(long l, int n) {
        return new JackEvent(l, 1, new byte[]{81, (byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF)});
    }
}

