/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack;

public class JackClient {
    private static final String JNI_LIBRARY_NAME = new String("tuxguitar-jack-jni");
    private long instance = this.malloc();
    private boolean open = false;
    private boolean openPorts = false;
    private boolean openTransport;

    public void finalize() {
        if (this.instance != 0L) {
            this.free(this.instance);
            this.instance = 0L;
        }
    }

    private void open() {
        if (this.instance != 0L && !this.open) {
            this.open(this.instance);
            this.open = true;
        }
    }

    private void close(boolean bl) {
        if (bl) {
            this.closePorts();
            this.closeTransport();
        }
        if (!this.isPortsOpen() && !this.isTransportOpen() && this.instance != 0L && this.open) {
            this.close(this.instance);
            this.open = false;
        }
    }

    public void close() {
        this.close(true);
    }

    public boolean isOpen() {
        return this.instance != 0L && this.open;
    }

    public boolean isPortsOpen() {
        return this.isOpen() && this.openPorts;
    }

    public void openPorts(int n) {
        if (!this.isOpen()) {
            this.open();
        }
        if (this.isOpen() && !this.openPorts) {
            this.openPorts(this.instance, n);
            this.openPorts = true;
        }
    }

    public void closePorts() {
        if (this.isOpen() && this.openPorts) {
            this.closePorts(this.instance);
            this.openPorts = false;
        }
        this.close(false);
    }

    public boolean isTransportOpen() {
        return this.isOpen() && this.openTransport;
    }

    public void openTransport() {
        if (!this.isOpen()) {
            this.open();
        }
        if (this.isOpen() && !this.openTransport) {
            this.openTransport = true;
        }
    }

    public void closeTransport() {
        if (this.isOpen() && this.openTransport) {
            this.openTransport = false;
        }
        this.close(false);
    }

    public void addEventToQueue(int n, byte[] byArray) {
        if (this.instance != 0L && this.open) {
            this.addEventToQueue(this.instance, n, byArray);
        }
    }

    public long getTransportUID() {
        if (this.instance != 0L && this.open) {
            return this.getTransportUID(this.instance);
        }
        return 0L;
    }

    public long getTransportFrame() {
        if (this.instance != 0L && this.open) {
            return this.getTransportFrame(this.instance);
        }
        return 0L;
    }

    public long getTransportFrameRate() {
        if (this.instance != 0L && this.open) {
            return this.getTransportFrameRate(this.instance);
        }
        return 0L;
    }

    public void setTransportFrame(long l) {
        if (this.instance != 0L && this.open) {
            this.setTransportFrame(this.instance, l);
        }
    }

    public void setTransportStart() {
        if (this.instance != 0L && this.open) {
            this.setTransportStart(this.instance);
        }
    }

    public void setTransportStop() {
        if (this.instance != 0L && this.open) {
            this.setTransportStop(this.instance);
        }
    }

    public boolean isTransportRunning() {
        if (this.instance != 0L && this.open) {
            return this.isTransportRunning(this.instance);
        }
        return false;
    }

    public boolean isServerRunning() {
        if (this.instance != 0L && this.open) {
            if (this.isServerRunning(this.instance)) {
                return true;
            }
            this.close(true);
        }
        return false;
    }

    private native long malloc();

    private native void free(long var1);

    private native void open(long var1);

    private native void close(long var1);

    private native void openPorts(long var1, int var3);

    private native void closePorts(long var1);

    private native long getTransportUID(long var1);

    private native long getTransportFrame(long var1);

    private native long getTransportFrameRate(long var1);

    private native void setTransportFrame(long var1, long var3);

    private native void setTransportStart(long var1);

    private native void setTransportStop(long var1);

    private native boolean isTransportRunning(long var1);

    private native boolean isServerRunning(long var1);

    private native void addEventToQueue(long var1, int var3, byte[] var4);

    static {
        System.loadLibrary(JNI_LIBRARY_NAME);
    }
}

