/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.fluidsynth;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gui.system.config.TGConfigManager;
import org.herac.tuxguitar.gui.system.plugins.TGPluginConfigManager;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.MidiOutputPortProviderImpl;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.MidiSynth;

public class MidiSettings {
    public static final String AUDIO_DRIVER = "audio.driver";
    public static final String AUDIO_SAMPLE_FORMAT = "audio.sample-format";
    public static final String AUDIO_PERIOD_SIZE = "audio.period-size";
    public static final String AUDIO_PERIOD_COUNT = "audio.periods";
    public static final String SYNTH_GAIN = "synth.gain";
    public static final String SYNTH_POLYPHONY = "synth.polyphony";
    public static final String SYNTH_SAMPLE_RATE = "synth.sample-rate";
    public static final String SYNTH_REVERB_ACTIVE = "synth.reverb.active";
    public static final String SYNTH_CHORUS_ACTIVE = "synth.chorus.active";
    public static final String SYNTH_AUDIO_CHANNELS = "synth.audio-channels";
    public static final String SYNTH_AUDIO_GROUPS = "synth.audio-groups";
    private TGConfigManager config;
    private MidiOutputPortProviderImpl provider;
    private boolean restartSynth;

    public MidiSettings(MidiOutputPortProviderImpl midiOutputPortProviderImpl) {
        this.provider = midiOutputPortProviderImpl;
    }

    public MidiSynth getSynth() {
        return this.provider.getSynth();
    }

    public TGConfigManager getConfig() {
        if (this.config == null) {
            this.config = new TGPluginConfigManager("tuxguitar-fluidsynth");
            this.config.init();
        }
        return this.config;
    }

    public double getDoubleValue(String string) {
        return this.getConfig().getDoubleConfigValue(string, this.getSynth().getDoubleProperty(string));
    }

    public int getIntegerValue(String string) {
        return this.getConfig().getIntConfigValue(string, this.getSynth().getIntegerProperty(string));
    }

    public String getStringValue(String string) {
        return this.getConfig().getStringConfigValue(string, this.getSynth().getStringProperty(string));
    }

    public boolean getBooleanValue(String string) {
        String string2 = this.getStringValue(string);
        return string2 != null && string2.equals("yes");
    }

    public void setDoubleValue(String string, double d) {
        this.getConfig().setProperty(string, d);
    }

    public void setIntegerValue(String string, int n) {
        this.getConfig().setProperty(string, n);
    }

    public void setStringValue(String string, String string2) {
        if (string2 == null) {
            this.getConfig().removeProperty(string);
        } else {
            this.getConfig().setProperty(string, string2);
        }
    }

    public void setBooleanValue(String string, boolean bl) {
        this.setStringValue(string, bl ? "yes" : "no");
    }

    public List getSoundfonts() {
        ArrayList<String> arrayList = new ArrayList<String>();
        TGConfigManager tGConfigManager = this.getConfig();
        int n = tGConfigManager.getIntConfigValue("soundfont.count");
        for (int i = 0; i < n; ++i) {
            String string = tGConfigManager.getStringConfigValue("soundfont.path" + i);
            if (string == null || string.length() <= 0) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public void setSoundfonts(List list) {
        TGConfigManager tGConfigManager = this.getConfig();
        tGConfigManager.setProperty("soundfont.count", list.size());
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            tGConfigManager.setProperty("soundfont.path" + i, string);
        }
    }

    public void save() {
        this.getConfig().save();
    }

    public void apply() {
        if (this.getSynth() != null && this.getSynth().isInitialized()) {
            this.restartSynth = false;
            this.applyStringProperty(AUDIO_DRIVER);
            this.applyStringProperty(AUDIO_SAMPLE_FORMAT);
            this.applyIntegerProperty(AUDIO_PERIOD_SIZE);
            this.applyIntegerProperty(AUDIO_PERIOD_COUNT);
            this.applyDoubleProperty(SYNTH_GAIN);
            this.applyDoubleProperty(SYNTH_SAMPLE_RATE);
            this.applyStringProperty(SYNTH_REVERB_ACTIVE);
            this.applyStringProperty(SYNTH_CHORUS_ACTIVE);
            this.applyIntegerProperty(SYNTH_POLYPHONY);
            if (this.restartSynth) {
                this.getSynth().reconnect();
                this.restartSynth = false;
            }
        }
    }

    private void applyStringProperty(String string) {
        String string2 = this.getStringValue(string);
        String string3 = this.getSynth().getStringProperty(string);
        if (!(string2 == null || string3 != null && string2.equals(string3))) {
            this.getSynth().setStringProperty(string, string2);
            this.restartSynth = this.restartSynth || !this.getSynth().isRealtimeProperty(string);
        }
    }

    private void applyDoubleProperty(String string) {
        double d;
        double d2 = this.getDoubleValue(string);
        if (d2 != (d = this.getSynth().getDoubleProperty(string))) {
            this.getSynth().setDoubleProperty(string, d2);
            this.restartSynth = this.restartSynth || !this.getSynth().isRealtimeProperty(string);
        }
    }

    private void applyIntegerProperty(String string) {
        int n;
        int n2 = this.getIntegerValue(string);
        if (n2 != (n = this.getSynth().getIntegerProperty(string))) {
            this.getSynth().setIntegerProperty(string, n2);
            this.restartSynth = this.restartSynth || !this.getSynth().isRealtimeProperty(string);
        }
    }
}

