/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.alsa;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.player.impl.midiport.alsa.MidiOutputPortImpl;

public class MidiSystem {
    private static final String JNI_LIBRARY_NAME = new String("tuxguitar-alsa-jni");
    private long instance = this.malloc();
    private boolean open = false;
    private List ports = new ArrayList();

    public boolean isOpen() {
        return this.instance != 0L && this.open;
    }

    public void finalize() {
        if (this.instance != 0L) {
            this.free(this.instance);
            this.instance = 0L;
        }
    }

    public void open() {
        if (this.instance != 0L && !this.open) {
            this.open(this.instance);
            this.open = true;
        }
    }

    public void close() {
        if (this.instance != 0L && this.open) {
            this.close(this.instance);
            this.open = false;
        }
    }

    public List findPorts() {
        this.ports.clear();
        if (this.instance != 0L && this.open) {
            this.findPorts(this.instance);
        }
        return this.ports;
    }

    public void openPort(int n, int n2) {
        if (this.instance != 0L && this.open) {
            this.openPort(this.instance, n, n2);
        }
    }

    public void closePort() {
        if (this.instance != 0L && this.open) {
            this.closePort(this.instance);
        }
    }

    public void noteOn(int n, int n2, int n3) {
        if (this.instance != 0L && this.open) {
            this.noteOn(this.instance, n, n2, n3);
        }
    }

    public void noteOff(int n, int n2, int n3) {
        if (this.instance != 0L && this.open) {
            this.noteOff(this.instance, n, n2, n3);
        }
    }

    public void controlChange(int n, int n2, int n3) {
        if (this.instance != 0L && this.open) {
            this.controlChange(this.instance, n, n2, n3);
        }
    }

    public void programChange(int n, int n2) {
        if (this.instance != 0L && this.open) {
            this.programChange(this.instance, n, n2);
        }
    }

    public void pitchBend(int n, int n2) {
        if (this.instance != 0L && this.open) {
            this.pitchBend(this.instance, n, n2);
        }
    }

    protected void addPort(String string, int n, int n2) {
        this.ports.add(new MidiOutputPortImpl(this, string, n, n2));
    }

    private native long malloc();

    private native void free(long var1);

    private native void open(long var1);

    private native void close(long var1);

    private native void findPorts(long var1);

    private native void openPort(long var1, int var3, int var4);

    private native void closePort(long var1);

    private native void noteOn(long var1, int var3, int var4, int var5);

    private native void noteOff(long var1, int var3, int var4, int var5);

    private native void controlChange(long var1, int var3, int var4, int var5);

    private native void programChange(long var1, int var3, int var4);

    private native void pitchBend(long var1, int var3, int var4);

    static {
        System.loadLibrary(JNI_LIBRARY_NAME);
    }
}

