/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.midi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;

class SongAdjuster {
    private TGFactory factory;
    private TGSong song;
    private long minDurationTime;

    public SongAdjuster(TGFactory tGFactory, TGSong tGSong) {
        this.factory = tGFactory;
        this.song = tGSong;
        this.minDurationTime = 40L;
    }

    public TGSong adjustSong() {
        Iterator iterator = this.song.getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack = (TGTrack)iterator.next();
            this.adjustTrack(tGTrack);
        }
        return this.song;
    }

    private void adjustTrack(TGTrack tGTrack) {
        Iterator iterator = tGTrack.getMeasures();
        while (iterator.hasNext()) {
            TGMeasure tGMeasure = (TGMeasure)iterator.next();
            this.process(tGMeasure);
        }
    }

    public void process(TGMeasure tGMeasure) {
        this.orderBeats(tGMeasure);
        this.joinBeats(tGMeasure);
        this.adjustStrings(tGMeasure);
    }

    public void joinBeats(TGMeasure tGMeasure) {
        TGBeat tGBeat = null;
        boolean bl = true;
        long l = tGMeasure.getStart();
        long l2 = l + tGMeasure.getLength();
        for (int i = 0; i < tGMeasure.countBeats(); ++i) {
            TGBeat tGBeat2 = tGMeasure.getBeat(i);
            long l3 = tGBeat2.getStart();
            long l4 = tGBeat2.getVoice(0).getDuration().getTime();
            if (tGBeat != null) {
                long l5 = tGBeat.getStart();
                long l6 = tGBeat.getVoice(0).getDuration().getTime();
                if (l3 >= l5 && l5 + this.minDurationTime > l3) {
                    for (int j = 0; j < tGBeat2.getVoice(0).countNotes(); ++j) {
                        TGNote tGNote = tGBeat2.getVoice(0).getNote(j);
                        tGBeat.getVoice(0).addNote(tGNote);
                    }
                    if (!tGBeat.isChordBeat() && tGBeat2.isChordBeat()) {
                        tGBeat.setChord(tGBeat2.getChord());
                    }
                    if (!tGBeat.isTextBeat() && tGBeat2.isTextBeat()) {
                        tGBeat.setText(tGBeat2.getText());
                    }
                    if (l4 > l6 && l3 + l4 <= l2) {
                        tGBeat2.getVoice(0).getDuration().copy(tGBeat.getVoice(0).getDuration());
                    }
                    tGMeasure.removeBeat(tGBeat2);
                    bl = false;
                    break;
                }
                if (l5 < l3 && l5 + l6 > l3) {
                    if (tGBeat2.getVoice(0).isRestVoice()) {
                        tGMeasure.removeBeat(tGBeat2);
                        bl = false;
                        break;
                    }
                    TGDuration tGDuration = TGDuration.fromTime((TGFactory)this.factory, (long)(l3 - l5));
                    tGDuration.copy(tGBeat.getVoice(0).getDuration());
                }
            }
            if (l3 + l4 > l2) {
                if (tGBeat2.getVoice(0).isRestVoice()) {
                    tGMeasure.removeBeat(tGBeat2);
                    bl = false;
                    break;
                }
                TGDuration tGDuration = TGDuration.fromTime((TGFactory)this.factory, (long)(l2 - l3));
                tGDuration.copy(tGBeat2.getVoice(0).getDuration());
            }
            tGBeat = tGBeat2;
        }
        if (!bl) {
            this.joinBeats(tGMeasure);
        }
    }

    public void orderBeats(TGMeasure tGMeasure) {
        for (int i = 0; i < tGMeasure.countBeats(); ++i) {
            TGBeat tGBeat = null;
            for (int j = i; j < tGMeasure.countBeats(); ++j) {
                TGBeat tGBeat2 = tGMeasure.getBeat(j);
                if (tGBeat != null && tGBeat2.getStart() >= tGBeat.getStart()) continue;
                tGBeat = tGBeat2;
            }
            tGMeasure.moveBeat(i, tGBeat);
        }
    }

    private void adjustStrings(TGMeasure tGMeasure) {
        for (int i = 0; i < tGMeasure.countBeats(); ++i) {
            TGBeat tGBeat = tGMeasure.getBeat(i);
            this.adjustStrings(tGBeat);
        }
    }

    private void adjustStrings(TGBeat tGBeat) {
        TGTrack tGTrack = tGBeat.getMeasure().getTrack();
        ArrayList arrayList = new ArrayList(tGTrack.getStrings());
        ArrayList<TGNote> arrayList2 = new ArrayList<TGNote>();
        Iterator iterator = tGBeat.getVoice(0).getNotes().iterator();
        while (iterator.hasNext()) {
            TGNote tGNote = (TGNote)iterator.next();
            int n = this.getStringForValue(arrayList, tGNote.getValue());
            for (int i = 0; i < arrayList.size(); ++i) {
                TGString tGString = (TGString)arrayList.get(i);
                if (tGString.getNumber() != n) continue;
                tGNote.setValue(tGNote.getValue() - tGString.getValue());
                tGNote.setString(tGString.getNumber());
                arrayList.remove(i);
                break;
            }
            if (tGNote.getString() >= 1) continue;
            arrayList2.add(tGNote);
        }
        while (arrayList2.size() > 0) {
            tGBeat.getVoice(0).removeNote((TGNote)arrayList2.get(0));
            arrayList2.remove(0);
        }
    }

    private int getStringForValue(List list, int n) {
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < list.size(); ++i) {
            TGString tGString = (TGString)list.get(i);
            int n4 = n - tGString.getValue();
            if (n2 >= 0 && (n4 < 0 || n4 >= n2)) continue;
            n3 = tGString.getNumber();
            n2 = n4;
        }
        return n3;
    }
}

