/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.midi;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.io.midi.MidiSettings;

public class MidiSettingsDialog {
    public static final int MAX_TRANSPOSE = 24;
    public static final int MIN_TRANSPOSE = -24;
    private static final int STATUS_NONE = 0;
    private static final int STATUS_CANCELLED = 1;
    private static final int STATUS_ACCEPTED = 2;
    protected int status;
    protected MidiSettings settings = new MidiSettings();

    public MidiSettings open() {
        this.status = 0;
        final Shell shell = DialogUtils.newDialog((Shell)TuxGuitar.instance().getShell(), (int)67680);
        shell.setLayout((Layout)new GridLayout());
        shell.setText("Options");
        Group group = new Group((Composite)shell, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)this.getGroupData());
        group.setText("Transpose notes");
        Label label = new Label((Composite)group, 0);
        label.setText("Transpose:");
        label.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        final Combo combo = new Combo((Composite)group, 12);
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        for (int i = -24; i <= 24; ++i) {
            combo.add(Integer.toString(i));
        }
        combo.select(24);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        Button button = new Button(composite, 8);
        button.setText(TuxGuitar.getProperty((String)"ok"));
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MidiSettingsDialog.this.status = 2;
                MidiSettingsDialog.this.settings.setTranspose(-24 + combo.getSelectionIndex());
                shell.dispose();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(TuxGuitar.getProperty((String)"cancel"));
        button2.setLayoutData((Object)gridData);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MidiSettingsDialog.this.status = 1;
                shell.dispose();
            }
        });
        shell.setDefaultButton(button);
        DialogUtils.openDialog((Shell)shell, (int)11);
        return this.status == 2 ? this.settings : null;
    }

    private GridData getGroupData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 300;
        return gridData;
    }
}

