/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.midi;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.herac.tuxguitar.io.midi.MidiFileException;
import org.herac.tuxguitar.io.midi.MidiFileHeader;
import org.herac.tuxguitar.io.midi.base.MidiEvent;
import org.herac.tuxguitar.io.midi.base.MidiMessage;
import org.herac.tuxguitar.io.midi.base.MidiSequence;
import org.herac.tuxguitar.io.midi.base.MidiTrack;

public class MidiFileReader
implements MidiFileHeader {
    public static boolean CANCEL_RUNNING_STATUS_ON_META_AND_SYSEX = true;
    private static final int STATUS_NONE = 0;
    private static final int STATUS_ONE_BYTE = 1;
    private static final int STATUS_TWO_BYTES = 2;
    private static final int STATUS_SYSEX = 3;
    private static final int STATUS_META = 4;

    public MidiSequence getSequence(InputStream inputStream) throws MidiFileException, IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (dataInputStream.readInt() != 1297377380) {
            throw new MidiFileException("not a MIDI file: wrong header magic");
        }
        int n = dataInputStream.readInt();
        if (n < 6) {
            throw new MidiFileException("corrupt MIDI file: wrong header length");
        }
        short s = dataInputStream.readShort();
        if (s < 0 || s > 2) {
            throw new MidiFileException("corrupt MIDI file: illegal type");
        }
        if (s == 2) {
            throw new MidiFileException("this implementation doesn't support type 2 MIDI files");
        }
        int n2 = dataInputStream.readShort();
        if (n2 <= 0) {
            throw new MidiFileException("corrupt MIDI file: number of tracks must be positive");
        }
        if (s == 0 && n2 != 1) {
            throw new MidiFileException("corrupt MIDI file:  type 0 files must contain exactely one track");
        }
        float f = -1.0f;
        int n3 = -1;
        int n4 = dataInputStream.readUnsignedShort();
        if ((n4 & 0x8000) != 0) {
            int n5 = -(n4 >>> 8 & 0xFF);
            if (n5 == 24) {
                f = 24.0f;
            } else if (n5 == 25) {
                f = 25.0f;
            } else if (n5 == 29) {
                f = 29.97f;
            } else if (n5 == 30) {
                f = 30.0f;
            } else {
                throw new MidiFileException("corrupt MIDI file: illegal frame division type");
            }
            n3 = n4 & 0xFF;
        } else {
            f = 0.0f;
            n3 = n4 & Short.MAX_VALUE;
        }
        dataInputStream.skip(n - 6);
        MidiSequence midiSequence = new MidiSequence(f, n3);
        for (int i = 0; i < n2; ++i) {
            MidiTrack midiTrack = new MidiTrack();
            midiSequence.addTrack(midiTrack);
            this.readTrack(dataInputStream, midiTrack);
        }
        dataInputStream.close();
        return midiSequence;
    }

    private void readTrack(DataInputStream dataInputStream, MidiTrack midiTrack) throws MidiFileException, IOException {
        while (dataInputStream.readInt() != 1297379947) {
            int n = dataInputStream.readInt();
            if (n % 2 != 0) {
                ++n;
            }
            dataInputStream.skip(n);
        }
        MidiTrackReaderHelper midiTrackReaderHelper = new MidiTrackReaderHelper(0L, dataInputStream.readInt(), -1);
        while (midiTrackReaderHelper.remainingBytes > 0L) {
            midiTrackReaderHelper.ticks += MidiFileReader.readVariableLengthQuantity(dataInputStream, midiTrackReaderHelper);
            MidiEvent midiEvent = MidiFileReader.readEvent(dataInputStream, midiTrackReaderHelper);
            if (midiEvent == null) continue;
            midiTrack.add(midiEvent);
        }
    }

    private static MidiEvent readEvent(DataInputStream dataInputStream, MidiTrackReaderHelper midiTrackReaderHelper) throws MidiFileException, IOException {
        int n;
        int n2 = MidiFileReader.readUnsignedByte(dataInputStream, midiTrackReaderHelper);
        int n3 = 0;
        boolean bl = false;
        if (n2 < 128) {
            if (midiTrackReaderHelper.runningStatusByte != -1) {
                bl = true;
                n3 = n2;
                n2 = midiTrackReaderHelper.runningStatusByte;
            } else {
                throw new MidiFileException("corrupt MIDI file: status byte missing");
            }
        }
        if ((n = MidiFileReader.getType(n2)) == 1) {
            int n4 = 0;
            if (bl) {
                n4 = n3;
            } else {
                n4 = MidiFileReader.readUnsignedByte(dataInputStream, midiTrackReaderHelper);
                midiTrackReaderHelper.runningStatusByte = n2;
            }
            return new MidiEvent(MidiMessage.shortMessage(n2 & 0xF0, n2 & 0xF, n4), midiTrackReaderHelper.ticks);
        }
        if (n == 2) {
            int n5 = 0;
            if (bl) {
                n5 = n3;
            } else {
                n5 = MidiFileReader.readUnsignedByte(dataInputStream, midiTrackReaderHelper);
                midiTrackReaderHelper.runningStatusByte = n2;
            }
            return new MidiEvent(MidiMessage.shortMessage(n2 & 0xF0, n2 & 0xF, n5, MidiFileReader.readUnsignedByte(dataInputStream, midiTrackReaderHelper)), midiTrackReaderHelper.ticks);
        }
        if (n == 3) {
            if (CANCEL_RUNNING_STATUS_ON_META_AND_SYSEX) {
                midiTrackReaderHelper.runningStatusByte = -1;
            }
            int n6 = (int)MidiFileReader.readVariableLengthQuantity(dataInputStream, midiTrackReaderHelper);
            byte[] byArray = new byte[n6];
            for (int i = 0; i < n6; ++i) {
                byArray[i] = (byte)MidiFileReader.readUnsignedByte(dataInputStream, midiTrackReaderHelper);
            }
        } else if (n == 4) {
            if (CANCEL_RUNNING_STATUS_ON_META_AND_SYSEX) {
                midiTrackReaderHelper.runningStatusByte = -1;
            }
            int n7 = MidiFileReader.readUnsignedByte(dataInputStream, midiTrackReaderHelper);
            int n8 = (int)MidiFileReader.readVariableLengthQuantity(dataInputStream, midiTrackReaderHelper);
            byte[] byArray = new byte[n8];
            for (int i = 0; i < n8; ++i) {
                byArray[i] = (byte)MidiFileReader.readUnsignedByte(dataInputStream, midiTrackReaderHelper);
            }
            return new MidiEvent(MidiMessage.metaMessage(n7, byArray), midiTrackReaderHelper.ticks);
        }
        return null;
    }

    private static int getType(int n) {
        if (n < 240) {
            int n2 = n & 0xF0;
            if (n2 == 128 || n2 == 144 || n2 == 160 || n2 == 176 || n2 == 224) {
                return 2;
            }
            if (n2 == 192 || n2 == 208) {
                return 1;
            }
            return 0;
        }
        if (n == 240 || n == 247) {
            return 3;
        }
        if (n == 255) {
            return 4;
        }
        return 0;
    }

    public static long readVariableLengthQuantity(DataInputStream dataInputStream, MidiTrackReaderHelper midiTrackReaderHelper) throws MidiFileException, IOException {
        int n = 0;
        long l = 0L;
        while (n < 4) {
            int n2 = MidiFileReader.readUnsignedByte(dataInputStream, midiTrackReaderHelper);
            ++n;
            l <<= 7;
            l |= (long)(n2 & 0x7F);
            if (n2 >= 128) continue;
            return l;
        }
        throw new MidiFileException("not a MIDI file: unterminated variable-length quantity");
    }

    public static int readUnsignedByte(DataInputStream dataInputStream, MidiTrackReaderHelper midiTrackReaderHelper) throws IOException {
        --midiTrackReaderHelper.remainingBytes;
        return dataInputStream.readUnsignedByte();
    }

    private class MidiTrackReaderHelper {
        protected long ticks = 0L;
        protected long remainingBytes;
        protected int runningStatusByte;

        protected MidiTrackReaderHelper(long l, long l2, int n) {
            this.ticks = l;
            this.remainingBytes = l2;
            this.runningStatusByte = n;
        }
    }
}

