/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.custom.tuner;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import org.herac.tuxguitar.gui.tools.custom.tuner.TGTuner;
import org.herac.tuxguitar.gui.util.MessageDialog;

public class TGTunerSettings {
    protected int sampleSize;
    protected float sampleRate;
    protected String deviceName;
    protected double treshold;
    protected int bufferSize;
    protected int fftSize;
    protected int waitPeriod;
    static final int DEFAULT_BUFFER_SIZE = 4096;
    static final int DEFAULT_FFT_SIZE = 16384;
    static final int CHANNELS_NUMBER = 1;

    public static TGTunerSettings getDefaults() {
        TGTunerSettings tGTunerSettings = new TGTunerSettings();
        tGTunerSettings.setSampleRate(11025.0f);
        tGTunerSettings.setSampleSize(8);
        tGTunerSettings.setBufferSize(4096);
        tGTunerSettings.setFFTSize(16384);
        tGTunerSettings.setTreshold(0.03);
        tGTunerSettings.setWaitPeriod(100);
        return tGTunerSettings;
    }

    protected static TargetDataLine getDataLine(TGTunerSettings tGTunerSettings) throws TGTuner.TGTunerException {
        TargetDataLine targetDataLine = null;
        if (tGTunerSettings != null) {
            DataLine.Info info = tGTunerSettings.getDataLineInfo();
            try {
                targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
            }
            catch (Exception exception) {
                MessageDialog.errorMessage((Throwable)exception);
            }
        } else {
            throw new TGTuner.TGTunerException("Could not retrieve data from the input. Check your system device settings.");
        }
        return targetDataLine;
    }

    protected DataLine.Info getDataLineInfo() {
        return new DataLine.Info(TargetDataLine.class, this.getAudioFormat(), this.getBufferSize());
    }

    public AudioFormat getAudioFormat() {
        return new AudioFormat(this.getSampleRate(), this.getSampleSize(), 1, true, false);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public int getFFTSize() {
        return this.fftSize;
    }

    public void setFFTSize(int n) {
        this.fftSize = n;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public double getTreshold() {
        return this.treshold;
    }

    public void setTreshold(double d) {
        this.treshold = d;
    }

    public void setSampleRate(float f) {
        this.sampleRate = f;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(int n) {
        this.sampleSize = n;
    }

    public int getWaitPeriod() {
        return this.waitPeriod;
    }

    public void setWaitPeriod(int n) {
        this.waitPeriod = n;
    }

    public static TGTunerSettings loadTuxGuitarSettings() throws TGTuner.TGTunerException {
        return TGTunerSettings.getDefaults();
    }
}

