/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.custom.tuner;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.tools.custom.tuner.TGTunerRoughWidget;

public class TGTunerFineWidget
extends Composite {
    private static final int MIN_HEIGHT = 60;
    private static final int MIN_WIDTH = 80;
    private final float bottomY = 10.0f;
    private Composite composite = null;
    protected String currentNoteString = null;
    protected int currentNoteValue = -1;
    protected double currentFrequency = 0.0;
    protected Font letterFont = null;
    protected final float FINE_TUNING_RANGE = 1.5f;

    public TGTunerFineWidget(Composite composite) {
        super(composite, 0);
        this.setEnabled(false);
        this.init();
    }

    protected void init() {
        this.setLayout((Layout)new GridLayout(1, true));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.composite = new Composite((Composite)this, 0x20000800);
        this.composite.setBackground(this.getDisplay().getSystemColor(1));
        this.composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                TGPainter tGPainter = new TGPainter(paintEvent.gc);
                TGTunerFineWidget.this.paintWidget(tGPainter);
            }
        });
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 60;
        gridData.minimumWidth = 80;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.composite.setLayoutData((Object)gridData);
        this.letterFont = new Font((Device)this.getDisplay(), TuxGuitar.instance().getConfig().getFontDataConfigValue("matrix.font").getName(), 14, 1);
    }

    public void paintWidget(TGPainter tGPainter) {
        Point point = this.composite.getSize();
        tGPainter.setForeground(this.getDisplay().getSystemColor(2));
        tGPainter.initPath();
        tGPainter.setLineWidth(2);
        float f = (float)point.y - this.bottomY - 25.0f;
        tGPainter.moveTo((float)(point.x / 2), (float)point.y - this.bottomY);
        tGPainter.lineTo((float)(point.x / 2), 25.0f);
        tGPainter.closePath();
        tGPainter.initPath();
        f = Math.min(f, (float)(point.x / 2));
        tGPainter.moveTo((float)(point.x / 2) - f, (float)point.y - this.bottomY);
        tGPainter.lineTo((float)(point.x / 2) + f, (float)point.y - this.bottomY);
        tGPainter.closePath();
        if (this.isEnabled()) {
            tGPainter.setForeground(this.getDisplay().getSystemColor(9));
            tGPainter.setFont(this.letterFont);
            tGPainter.drawString(this.currentNoteString, point.x * 12 / 15, 10);
            if (this.currentFrequency != -1.0) {
                tGPainter.setLineWidth(3);
                tGPainter.setForeground(this.getDisplay().getSystemColor(3));
                tGPainter.initPath();
                tGPainter.moveTo((float)(point.x / 2), (float)point.y - this.bottomY);
                tGPainter.lineTo((float)((double)(point.x / 2) + (double)f * Math.cos(this.getAngleRad())), (float)((double)((float)point.y - this.bottomY) - (double)f * Math.sin(this.getAngleRad())));
                tGPainter.closePath();
            }
        }
    }

    public void setWantedTone(int n) {
        this.setEnabled(true);
        this.currentNoteValue = n;
        this.currentNoteString = TGTunerRoughWidget.TONESSTRING[n % 12] + (int)Math.floor(n / 12);
        this.redraw();
    }

    public void setCurrentFrequency(double d) {
        this.currentFrequency = d;
        this.redraw();
    }

    public void redraw() {
        super.redraw();
        this.composite.redraw();
    }

    protected double getAngleRad() {
        double d = this.stickDistance(this.getTone(this.currentFrequency) - (float)this.currentNoteValue);
        ((Object)((Object)this)).getClass();
        return Math.PI * (1.0 - (d + 1.5) / (double)(2.0f * this.FINE_TUNING_RANGE));
    }

    private float getTone(double d) {
        return (float)(45.0 + 12.0 * (Math.log(d / 110.0) / Math.log(2.0)));
    }

    private double stickDistance(double d) {
        double d2 = Math.abs(d);
        ((Object)((Object)this)).getClass();
        if (d2 > 1.5) {
            if (d > 0.0) {
                ((Object)((Object)this)).getClass();
                return 1.5;
            }
            return -this.FINE_TUNING_RANGE;
        }
        return d;
    }
}

