/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2006-2010 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#ifndef GMWINDOW_H
#define GMWINDOW_H

class GMRemote;
class GMTrackView;
class GMSourceView;
class GMIconTheme;
class GMPreferencesDialog;
class GMImageView;

enum {
  DISPLAYMODE_UNDEFINED=-1,
  DISPLAYMODE_NORMAL=0,
  DISPLAYMODE_LIST=1,
  };


enum {
  SHOW_NORMAL,
  SHOW_WIZARD,
  SHOW_TRAY
  };

class GMWindow : public FXMainWindow {
  FXDECLARE(GMWindow)
friend class GMRemote;
friend class GMPlayerManager;
friend class GMTrackView;
friend class GMPreferencesDialog;
private:
  FXMenuPtr         filemenu;
  FXMenuPtr         editmenu;
  FXMenuPtr         viewmenu;
  FXMenuPtr         playmenu;
  FXMenuPtr         helpmenu;
  FXMenuButton     *volumebutton;
  FXPopup          *volumecontrol;
  FXSlider         *volumeslider;
private:
  GMIconTheme       * icontheme;
  GMTrackView       * trackview;
  GMSourceView      * sourceview;
  FXHorizontalFrame * controlframe;
  FXHorizontalFrame * statusframe;
  FXHorizontalFrame * coverframe;
  GMImageView       * coverview_gl;
  FXImageFrame      * coverview_x11;
  FXGLVisual        * glvisual;
  FXToggleButton    * playpausebutton;
  FXButton          * stopbutton;
  FXButton          * nextbutton;
  FXButton          * prevbutton;
#if FOXVERSION > FXVERSION(1,7,11)
  FXMenuCheck       * fullscreencheck;
#endif
  FXSeparator       * controlseparator;
  FXDragCorner 			* controldragcorner;
  FXSeparator  			* controlstatusseparator;
  FX7Segment   			* timelabel;
  FXSlider     			* timeslider;
#if FOXVERSION > FXVERSION(1,7,21)
  FX4Splitter       * mainsplitter;
#else
  FXSplitter				* mainsplitter;
  FXSplitter        * sourcesplitter;
#endif
  FXStatusBar       * statusbar;
  FXTextField       * nowplaying;
  GMRemote          * remote;
private:
  FXString            coverfile;
private:
  FXFontPtr  font_thick;
  FXImagePtr cover_small;
private:
  void createFonts();
  void configureToolbar(FXbool docktop,FXbool showlabels,FXbool bigicons,FXbool init=false);
  void configureStatusbar(FXbool show);
#if FOXVERSION > FXVERSION(1,7,11)
  void setFullScreen(FXbool show);
#endif
private:
  GMWindow(){}
  GMWindow(const GMWindow&);
  GMWindow& operator=(const GMWindow&);
public: /// Message Handlers
  long onCmdAbout(FXObject*,FXSelector,void*);
  long onCmdQuit(FXObject*,FXSelector,void*);
  long onCmdPreferences(FXObject*,FXSelector,void*);

  long onCmdTimeSlider(FXObject*,FXSelector,void*);
  long onCmdVolume(FXObject*,FXSelector,void*);
  long onCmdVolumeButton(FXObject*,FXSelector,void*);
  long onUpdVolumeButton(FXObject*,FXSelector,void*);

  long onCmdOpen(FXObject*,FXSelector,void*);

  long onCmdImport(FXObject*,FXSelector,void*);
  long onCmdImportFiles(FXObject*,FXSelector,void*);
  long onCmdShowTrack(FXObject*,FXSelector,void*);
  long onUpdShowTrack(FXObject*,FXSelector,void*);

#if FOXVERSION >= FXVERSION(1,7,11)
  long onCmdShowFullScreen(FXObject*,FXSelector,void*);
#endif

#if FOXVERSION > FXVERSION(1,7,21)
  long onCmdShowSources(FXObject*,FXSelector,void*);
  long onUpdShowSources(FXObject*,FXSelector,void*);
#endif

  long onCmdShowMiniPlayer(FXObject*,FXSelector,void*);
  long onUpdShowMiniPlayer(FXObject*,FXSelector,void*);

  long onCmdPlayPause(FXObject*,FXSelector,void*);
  long onUpdPlayPause(FXObject*,FXSelector,void*);
  long onCmdPlayPauseMenu(FXObject*,FXSelector,void*);
  long onUpdPlayPauseMenu(FXObject*,FXSelector,void*);
  long onCmdPause(FXObject*,FXSelector,void*);
  long onUpdPause(FXObject*,FXSelector,void*);
  long onCmdStop(FXObject*,FXSelector,void*);
  long onUpdStop(FXObject*,FXSelector,void*);
  long onCmdNext(FXObject*,FXSelector,void*);
  long onUpdNext(FXObject*,FXSelector,void*);
  long onCmdPrev(FXObject*,FXSelector,void*);
  long onUpdPrev(FXObject*,FXSelector,void*);
  long onCmdRepeatAll(FXObject*,FXSelector,void*);
  long onUpdRepeatAll(FXObject*,FXSelector,void*);
  long onCmdRepeatAB(FXObject*,FXSelector,void*);
  long onUpdRepeatAB(FXObject*,FXSelector,void*);
  long onCmdRepeatOff(FXObject*,FXSelector,void*);
  long onUpdRepeatOff(FXObject*,FXSelector,void*);
  long onCmdRepeat(FXObject*,FXSelector,void*);
  long onUpdRepeat(FXObject*,FXSelector,void*);
  long onCmdSleepTimer(FXObject*,FXSelector,void*);
  long onUpdSleepTimer(FXObject*,FXSelector,void*);
  long onCmdShuffle(FXObject*,FXSelector,void*);
  long onUpdShuffle(FXObject*,FXSelector,void*);
  long onCmdHomePage(FXObject*,FXSelector,void*);
  long onCmdReportIssue(FXObject*,FXSelector,void*);
  long onCmdJoinLastFM(FXObject*,FXSelector,void*);
  long onCmdJoinGMMLastFM(FXObject*,FXSelector,void*);

  long onCmdResetColors(FXObject*,FXSelector,void*);
  long onCmdChangeCoverView(FXObject*,FXSelector,void*);
  long onCmdCoverView(FXObject*,FXSelector,void*);
  long onCmdCoverSize(FXObject*,FXSelector,void*);
  long onUpdCoverSize(FXObject*,FXSelector,void*);

public:
  enum{
    ID_ABOUT=FXMainWindow::ID_LAST,
    ID_QUIT,

    ID_OPEN,

    ID_HOMEPAGE,
    ID_REPORT_ISSUE,
    ID_JOIN_LASTFM,
    ID_JOIN_GMM_LASTFM,

    ID_PAUSE,
    ID_PLAYPAUSE,
    ID_PLAYPAUSEMENU,
    ID_STOP,
    ID_NEXT,
    ID_PREV,

    ID_REPEAT,
    ID_REPEAT_ALL,
    ID_REPEAT_AB,
    ID_REPEAT_OFF,
    ID_SHUFFLE,

    ID_TIMESLIDER,
    ID_VOLUME_BUTTON,
    ID_VOLUME_SLIDER,

    ID_DISPLAYMODE,

    ID_DATABASE_CLEAR,

    ID_IMPORT_DIRS,
    ID_IMPORT_FILES,
    ID_SYNC_DIRS,


    ID_PREFERENCES,
    ID_SHOW_TRACK,
#if FOXVERSION >= FXVERSION(1,7,11)
    ID_SHOW_FULLSCREEN,
    ID_SHOW_SOURCES,
#endif
    ID_SHOW_MINIPLAYER,

    ID_OPEN_DIR,
    ID_RESET_COLORS,

    ID_DDE_MESSAGE,
    ID_SLEEP,

    ID_COVERVIEW,
    ID_CHANGE_COVERVIEW,
    ID_COVERSIZE_SMALL,
    ID_COVERSIZE_MEDIUM,
    ID_COVERSIZE_LARGE,
    ID_COVERSIZE_EXTRALARGE,

    ID_LAST
    };
public:
  GMWindow(FXApp* a,FXObject*tgt,FXSelector sel);

  void showRemote();

  void hideRemote();

  GMRemote * getRemote() const { return remote; }

  void updateCoverView();


  void create_dialog_header(FXDialogBox * dialog,const FXString & title,const FXString & label,FXIcon * icon=NULL);

  FXbool question(const FXString & title,const FXString & label,const FXString & accept,const FXString & cancel);


  void reset();
  void display(const GMTrack&);


  void init(FXuint);


  void toggleShown();

  /// Create window
  virtual void create();

  virtual void show();

  virtual void hide();

  GMTrackView * getTrackView() const { return trackview; }
  GMSourceView  * getSourceView() const {return sourceview;}


  void loadCover(const FXString & filename);


  void update_elapsed_time(FXint hours,FXint minutes,FXint seconds,FXint position,FXbool playing,FXbool seekable);

  void update_volume_display(FXint level);


  FXFont * getThickFont() const { return font_thick; }

  FXImage * getSmallCover() const { return cover_small; }

  void layoutToolBarButtons();

  /// Destructor
  virtual ~GMWindow();
  };

#endif
