/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2006-2010 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#ifndef GMTRACKVIEW_H
#define GMTRACKVIEW_H

class GMList;
class GMTrackList;
class GMSource;
class GMHeaderButton;

class GMTrackView : public FXPacker {
FXDECLARE(GMTrackView)
protected:
  FX4Splitter       * browsersplit;
  FX4Splitter       * genresplit;
  FXVerticalFrame   * genrelistframe;
  FXHorizontalFrame * filterframe;
  FXTextField       * filterfield;
  FXListBox         * filterlist;
  GMTrackList       * tracklist;
  GMList            * genrelist;
  GMList            * artistlist;
  GMList            * albumlist;
  GMHeaderButton    * genrelistheader;
  GMHeaderButton    * artistlistheader;
  GMHeaderButton    * albumlistheader;
  FXMenuPtr           columnmenu;
  FXMenuPtr           sortmenu;
  FXMenuPtr           filtermenu;
protected:
  FXFontPtr           font_listhead;
protected:
  GMColumnList        columns;
  GMSource          * source;
  FXuint              sort_seed;
  FXuint              shuffle_seed;
  FXuint              filtermask;
public:
  static FXbool reverse_artist;
  static FXbool reverse_album;
  static FXbool album_by_year;
protected:
  FXint tracklist_dragging;
  FXint tracklist_lastline;
  FXint tracklist_lastposy;
  FXint tracklist_dropitem;
  FXint tracklist_posx;
  FXint tracklist_posy;
protected:
  GMTrackView();
  void initSelection(GMList * list,const FXchar *,const FXString & section="window");
  void saveSelection(GMList * list,const FXchar *,const FXString & section="window") const;
private:
  GMTrackView(const GMTrackView&);
  GMTrackView& operator=(const GMTrackView&);
public:
  enum {
    ID_ARTIST_LIST_HEADER = FX4Splitter::ID_LAST,
    ID_ALBUM_LIST_HEADER,
    ID_GENRE_LIST_HEADER,
    ID_ARTIST_LIST,
    ID_ALBUM_LIST,
    ID_GENRE_LIST,
    ID_TRACK_LIST,
    ID_TRACK_LIST_HEADER,
    ID_FILTER,
    ID_FILTER_MODE,
    ID_TOGGLE_BROWSER,
    ID_TOGGLE_GENRES,
    ID_TOGGLE_FILTER,
    ID_CLOSE_FILTER,
    ID_COPY,
    ID_CUT,
    ID_PASTE,
    ID_SHOW_CURRENT,
    ID_COLUMN_FIRST,
    ID_COLUMN_LAST=ID_COLUMN_FIRST+10,
    ID_SORT_FIRST,
    ID_SORT_LAST=ID_SORT_FIRST+10,
    ID_SORT_SHUFFLE,
    ID_SORT_BROWSE,
    ID_SORT_REVERSE,
    ID_SORT_DEFAULT,
    ID_CONFIGURE_COLUMNS,
    ID_LOAD_ALBUM_ICONS,
    ID_FILTER_TRACK,
    ID_FILTER_ALBUM,
    ID_FILTER_ARTIST,
    ID_FILTER_GENRE,
    ID_FILTER_LAST = ID_FILTER_GENRE,
    ID_LAST,
    };
public:
  long onCmdSortGenreList(FXObject*,FXSelector,void*);
  long onCmdSortArtistList(FXObject*,FXSelector,void*);
  long onCmdSortAlbumList(FXObject*,FXSelector,void*);

  long onCmdGenreSelected(FXObject*,FXSelector,void*);
  long onCmdArtistSelected(FXObject*,FXSelector,void*);
  long onCmdAlbumSelected(FXObject*,FXSelector,void*);

  long onGenreContextMenu(FXObject*,FXSelector,void*);
  long onArtistContextMenu(FXObject*,FXSelector,void*);
  long onAlbumContextMenu(FXObject*,FXSelector,void*);
  long onAlbumHeaderContextMenu(FXObject*,FXSelector,void*);
  long onTrackContextMenu(FXObject*,FXSelector,void*);
  long onTrackHeaderContextMenu(FXObject*,FXSelector,void*);

  long onCmdGenreKeyPress(FXObject*,FXSelector,void*);
  long onCmdArtistKeyPress(FXObject*,FXSelector,void*);
  long onCmdAlbumKeyPress(FXObject*,FXSelector,void*);
  long onCmdTrackKeyPress(FXObject*,FXSelector,void*);

  long onCmdFilter(FXObject*,FXSelector,void*);

  long onCmdFilterMask(FXObject*,FXSelector,void*);
  long onUpdFilterMask(FXObject*,FXSelector,void*);


  long onCmdBeginDrag(FXObject*,FXSelector,void*);
  long onCmdDragged(FXObject*,FXSelector,void*);
  long onCmdEndDrag(FXObject*,FXSelector,void*);

  long onDndTrackEnter(FXObject*,FXSelector,void*);
  long onDndTrackLeave(FXObject*,FXSelector,void*);
  long onDndTrackMotion(FXObject*,FXSelector,void*);
  long onDndTrackDrop(FXObject*,FXSelector,void*);

  long onDndMotion(FXObject*,FXSelector,void*);
  long onDndDrop(FXObject*,FXSelector,void*);
  long onDndRequest(FXObject*,FXSelector,void*);

  long onCmdPlayTrack(FXObject*,FXSelector,void*);

  long onCmdPaste(FXObject*,FXSelector,void*);
  long onUpdPaste(FXObject*,FXSelector,void*);

  long onCmdCopy(FXObject*,FXSelector,void*);
  long onUpdCopy(FXObject*,FXSelector,void*);

  long onCmdToggleBrowser(FXObject*,FXSelector,void*);
  long onUpdToggleBrowser(FXObject*,FXSelector,void*);

  long onCmdToggleGenres(FXObject*,FXSelector,void*);
  long onUpdToggleGenres(FXObject*,FXSelector,void*);

  long onCmdToggleFilter(FXObject*,FXSelector,void*);
  long onUpdToggleFilter(FXObject*,FXSelector,void*);

  long onCmdShowCurrent(FXObject*,FXSelector,void*);
  long onUpdShowCurrent(FXObject*,FXSelector,void*);

  long onCmdShowColumn(FXObject*,FXSelector,void*);
  long onUpdShowColumn(FXObject*,FXSelector,void*);

  long onCmdSortDefault(FXObject*,FXSelector,void*);
  long onCmdSort(FXObject*,FXSelector,void*);
  long onUpdSort(FXObject*,FXSelector,void*);
  long onUpdSortReverse(FXObject*,FXSelector,void*);
  long onCmdSortBrowse(FXObject*,FXSelector,void*);
  long onUpdSortBrowse(FXObject*,FXSelector,void*);
  long onCmdSortShuffle(FXObject*,FXSelector,void*);
  long onUpdSortShuffle(FXObject*,FXSelector,void*);

  long onCmdConfigureColumns(FXObject*,FXSelector,void*);
  long onCmdLoadAlbumIcons(FXObject*,FXSelector,void*);

public:
  GMTrackView(FXComposite* p);

  void updateFont();

  void updateColors();

  void updateIcons();

  FXMenuPane * getColumnMenu() const { return columnmenu; }

  FXMenuPane * getSortMenu() const { return sortmenu; }

  FXint numTrackSelected() const;

  FXbool trackSelected() const;

  FXbool hasTracks() const;

  void getSelectedGenres(FXIntList & genre) const;

  void getSelectedArtists(FXIntList & artists) const;

  void getSelectedAlbums(FXIntList & albums) const;

  void getSelectedTracks(FXIntList & tracks) const;

  void getTracks(FXIntList & tracks) const;

  GMTrackItem * getTrackItem(FXint i) const { return (GMTrackItem*)tracklist->getItem(i); }

  FXbool isTrackItemSelected(FXint i) const { return tracklist->isItemSelected(i); }

  FXint getNumTracks() const { return tracklist->getNumItems() ; }

  void selectGenreItem(FXint item);

  void selectAlbumItem(FXint item);

  void selectArtistItem(FXint item);

  void selectTrackItem(FXint item);

  inline FXint getGenre(FXint index) const { return (FXint)(FXival)genrelist->getItemData(index); }

  inline FXint getArtist(FXint index) const { return (FXint)(FXival)artistlist->getItemData(index); }

  inline FXint getAlbum(FXint index) const { return (FXint)(FXival)albumlist->getItemData(index); }

  inline FXint getTrack(FXint index) const { return (FXint)(FXival)tracklist->getItemId(index); }

  FXbool listGenres();

  FXbool listArtists();

  FXbool listAlbums();

  FXbool listTracks();

  FXint getCurrent() const;

  FXint getNext(FXbool wrap=false);

  FXint getPrevious();

  void setSource(GMSource * src);

  GMSource * getSource() const { return source; }

  FXString getTrackFilename(FXint i) const;

  void sortGenres() const;

  void sortArtists() const;

  void sortAlbums() const;

  void sortTracks() const;

  void resort();

  void init(GMSource * src);

  void refresh();

  void clear();

  void mark(FXint item,FXbool show=true);

  void showCurrent();

  void setSortMethod(FXint hdr,FXbool reverse=false);

  FXbool getSortReverse() const;

  void loadSettings(const FXString & key);

  void saveSettings(const FXString & key) const;

  void loadTrackSettings(const FXString & key);

  void saveTrackSettings(const FXString & key) const;

  void saveView() const;

  virtual ~GMTrackView();
  };



#endif
