/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2006-2010 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#ifndef GMSOURCE_H
#define GMSOURCE_H

class GMTrackList;
class GMList;
/*
enum {
  FLAG_CAN_AUTOPLAY	 =0x1,
  FLAG_CAN_FILTER		 =0x2,
  FLAG_CAN_BROWSE		 =0x4,
  FLAG_DEFAULT_BROWSE=0x8
  };
*/

enum {
  FILTER_TRACK    = 0x1,
  FILTER_ARTIST   = 0x2,
  FILTER_ALBUM    = 0x4,
  FILTER_GENRE    = 0x8,
  FILTER_ALL      = (FILTER_TRACK|FILTER_ARTIST|FILTER_ALBUM|FILTER_GENRE),
  FILTER_DEFAULT  = (FILTER_TRACK|FILTER_ARTIST|FILTER_ALBUM)
  };


class GMSource : public FXObject {
FXDECLARE(GMSource)
protected:
  FXIntList genre_selection;
  FXIntList artist_selection;
  FXIntList album_selection;
  FXint current_track;
  GMTrackListSortFunc sort_browse;
private:
  GMSource(const GMSource&);
  GMSource& operator=(const GMSource&);
public:
  enum {
    ID_TRACK_PLAYED = 1,
    ID_EDIT_GENRE,
    ID_EDIT_ARTIST,
    ID_EDIT_ALBUM,
    ID_EDIT_TRACK,
    ID_COPY_ARTIST,
    ID_COPY_ALBUM,
    ID_COPY_TRACK,
    ID_DELETE_GENRE,
    ID_DELETE_ARTIST,
    ID_DELETE_ALBUM,
    ID_DELETE_TRACK,
    ID_PASTE,
    ID_DROP,
    ID_EXPORT,
    ID_LAST
    };
public:
  GMSource();

  virtual void configure(GMColumnList&) const {}

  virtual void shuffle(GMTrackList*,FXuint) const{}

  virtual void orderChanged(GMTrackList*) const{}

  GMTrackListSortFunc getSortBrowse() const { return sort_browse; }

  virtual FXint getSortColumn(FXbool browse) const { if (browse) return HEADER_BROWSE; else return HEADER_ARTIST; }

  virtual FXIcon * getAlbumIcon(FXint,FXbool) {return NULL;}

  virtual FXIcon * getAlbumIcon() {return NULL;}

  void setCurrentTrack(FXint t) { current_track=t; }

  FXint getCurrentTrack() const { return current_track; }

  virtual FXbool hasCurrentTrack(GMSource * ) const { return false; }

  virtual FXbool hasTrack(const FXString &,FXint &) { return false; }

  virtual void resetCurrent() { current_track=-1; }

  virtual void markCurrent(GMTrackList * tracklist,FXint item);

  virtual FXbool findCurrent(GMTrackList * tracklist,GMSource * src);

  virtual FXbool findCurrentArtist(GMList * tracklist,GMSource * src);

  virtual FXbool findCurrentAlbum(GMList * tracklist,GMSource * src);

  virtual FXbool moveTrack(GMTrackList*,FXint,FXint) { return false;}

  virtual FXint getNumTracks() const;

  virtual FXString getTrackFilename(FXint id) const;

  virtual FXbool getTrack(GMTrack & info) const;

  virtual FXbool setTrack(GMTrack &) const { return false; }

  virtual FXint getType() const { return SOURCE_INVALID; }

  virtual FXbool getQueueColumn(FXbool) const { return false; }

  virtual FXbool canBrowse() const { return true; }

  virtual FXbool canFilter() const { return false; }

  virtual FXbool defaultBrowse() const { return true; }

  virtual FXbool autoPlay() const { return true; }

  virtual FXString getName() const { return FXString::null; }

  virtual FXString settingKey() const { return "nokey"; }

  virtual FXbool setFilter(const FXString&,FXuint) {return false;}

  virtual FXbool listGenres(GMList * genrelist,FXIcon * icon);

  virtual FXbool listArtists(GMList * artistlist,FXIcon * icon,const FXIntList & genrelist);

  virtual FXbool listAlbums(GMList * albumlist,FXIcon * icon,const FXIntList & artistlist,const FXIntList & genrelist);

  virtual FXbool listTracks(GMTrackList * tracklist,const FXIntList & albumlist,const FXIntList & genrelist);

  virtual FXbool genre_context_menu(FXMenuPane * pane);

  virtual FXbool artist_context_menu(FXMenuPane * pane);

  virtual FXbool album_context_menu(FXMenuPane * pane);

  virtual FXbool track_context_menu(FXMenuPane * pane);

  virtual FXbool source_context_menu(FXMenuPane * pane);

  virtual FXbool dnd_source_accepts(FXDragType*,FXuint) { return false; }

  virtual ~GMSource();
  };

typedef FXObjectListOf<GMSource> GMSourceList;



#endif
