/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2007-2010 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#ifndef GMDATABASESOURCE_H
#define GMDATABASESOURCE_H

#ifndef GMCLIPBOARD_H
#include "GMClipboard.h"
#endif

class GMSource;
class GMTrackDatabase;

class GMDatabaseClipboardData : public GMClipboardData {
public:
  GMTrackDatabase * db;
  FXIntList         tracks;
public:
  FXbool request(FXDragType target,GMClipboard * clipboard);

  ~GMDatabaseClipboardData() {
    db=NULL;
    }
  };

class GMDatabaseSource : public GMSource {
FXDECLARE(GMDatabaseSource)
protected:
  FXbool            dbowned;
  GMTrackDatabase * db;
  FXIntList         clipboard;
  FXHash            albumicons;
  FXString          filter;
  FXuint            filtermask;
  FXbool            hasfilter;
  static GMDatabaseSource* filterowner;
protected:
  GMDatabaseSource();
private:
  GMDatabaseSource(const GMDatabaseSource&);
  GMDatabaseSource& operator=(const GMDatabaseSource&);
protected:
  void clearAlbumIconCache();
  void removeFiles(const FXStringList & files);
  void getTrackFilenames(const FXIntList & tracks,FXStringList & files);
  virtual FXint getPlayList() const { return -1; }
  FXbool hasFilter() const { return hasfilter; }
public:
  enum {
    ID_NEW_PLAYLIST = GMSource::ID_LAST,
    ID_IMPORT_PLAYLIST,
    ID_EXPORT_GENRE,
    ID_EXPORT_ARTIST,
    ID_EXPORT_ALBUM,
    ID_EXPORT_TRACK,
    ID_CLEAR,
    ID_INFO,
    ID_COLUMN_TRACK,
    ID_COLUMN_QUEUE,
    ID_COLUMN_ARTIST,
    ID_COLUMN_ALBUM,
    ID_COLUMN_GENRE,
    ID_COLUMN_TIME,
    ID_LOAD_ALBUM_ICONS,
    ID_FILENAME_TEMPLATE,
    ID_OPEN_FOLDER,
    ID_LAST
    };
public:
  long onCmdEditTrack(FXObject*,FXSelector,void*);
  long onCmdDelete(FXObject*,FXSelector,void*);
  long onCmdCopyArtistAlbum(FXObject*,FXSelector,void*);
  long onCmdCopyTrack(FXObject*,FXSelector,void*);
  long onCmdRequestArtistAlbum(FXObject*,FXSelector,void*);
  long onCmdRequestTrack(FXObject*,FXSelector,void*);
  long onCmdExport(FXObject*,FXSelector,void*);
  long onUpdExport(FXObject*,FXSelector,void*);
  long onCmdExportTracks(FXObject*,FXSelector,void*);
  long onCmdDrop(FXObject*,FXSelector,void*);
  long onCmdPaste(FXObject*,FXSelector,void*);
  long onUpdPaste(FXObject*,FXSelector,void*);
  long onCmdNewPlayList(FXObject*,FXSelector,void*);
  long onCmdImportPlayList(FXObject*,FXSelector,void*);
  long onCmdClear(FXObject*,FXSelector,void*);
  long onCmdInfo(FXObject*,FXSelector,void*);
  long onCmdTrackPlayed(FXObject*,FXSelector,void*);
  long onCmdShowColumn(FXObject*,FXSelector,void*);
  long onUpdShowColumn(FXObject*,FXSelector,void*);
  long onCmdFilenameTemplate(FXObject*,FXSelector,void*);
  long onCmdOpenFolder(FXObject*,FXSelector,void*);
public:
  GMDatabaseSource(GMTrackDatabase * db);

  virtual FXbool canFilter() const { return true; }

  virtual void shuffle(GMTrackList*,FXuint) const;

  virtual void configure(GMColumnList&) const;

  virtual FXbool hasCurrentTrack(GMSource * ) const;

  virtual FXbool hasTrack(const FXString & mrl,FXint & id);

  virtual FXbool findCurrent(GMTrackList * tracklist,GMSource * src);

  virtual FXbool findCurrentArtist(GMList * tracklist,GMSource * src);

  virtual FXbool findCurrentAlbum(GMList * tracklist,GMSource * src);

  virtual FXIcon * getAlbumIcon(FXint id,FXbool cacheonly=false);

  virtual FXIcon * getAlbumIcon();

  void initPlaylists(GMSourceList & sources);

  virtual FXString getName() const { return notr("Music Library"); }

  virtual FXint getNumTracks() const;

  virtual FXint getNumStreams() const;

  virtual FXString getTrackFilename(FXint id) const;

  virtual FXbool getTrack(GMTrack & info) const;

  virtual FXint getType() const { return SOURCE_DATABASE; }

  virtual FXString settingKey() const { return "database"; }

  virtual FXbool setFilter(const FXString&,FXuint);

  virtual FXbool listGenres(GMList * genrelist,FXIcon * icon);

  virtual FXbool listArtists(GMList * artistlist,FXIcon * icon,const FXIntList & genrelist);

  virtual FXbool listAlbums(GMList * albumlist,FXIcon * icon,const FXIntList & artistlist,const FXIntList & genrelist);

  virtual FXbool listTracks(GMTrackList * tracklist,const FXIntList & albumlist,const FXIntList & genrelist);

  virtual FXbool genre_context_menu(FXMenuPane * pane);

  virtual FXbool artist_context_menu(FXMenuPane * pane);

  virtual FXbool album_context_menu(FXMenuPane * pane);

  virtual FXbool track_context_menu(FXMenuPane * pane);

  virtual FXbool source_context_menu(FXMenuPane * pane);

  virtual FXbool dnd_source_accepts(FXDragType*,FXuint);

  virtual ~GMDatabaseSource();
  };

#endif
