/////////////////////////////////////////////////////////////////////////////
// Name:        mediatrc.h
// Purpose:     Media Transcoder Interface
// Author:      Alex Thuering
// Created:     26.04.2008
// RCS-ID:      $Id: mediatrc.h,v 1.6 2010/10/10 16:11:04 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef WX_MEDIA_TRANSCODER_H
#define WX_MEDIA_TRANSCODER_H

#include "mediaenc.h"
#include "wx/dynarray.h"
#include <vector>

using namespace std;

enum FirstField {
	ffAUTO = -1,
	ffBOTTOM = 0,
	ffTOP = 1
};

class wxMediaTranscoder {
public:
	virtual ~wxMediaTranscoder() {}
	/** Adds input file. */
	virtual bool AddInputFile(const wxString& fileName, bool disableVideo = false,
			bool disableAudio = false, bool disableSubtitle = false) = 0;
	/** Sets output file and video/audio/subtitle formats. */
	virtual bool SetOutputFile(const wxString& fileName, VideoFormat videoFormat, AudioFormat audioFormat,
		SubtitleFormat subtitleFormat, int videoBitrate = 6000, bool vbr = false, int audioBitrate = 224) = 0;
	/** Sets output file and video/audio/subtitle formats. */
	virtual bool SetOutputFile(const wxString& fileName, VideoFormat videoFormat, wxArrayInt audioFormats,
		wxArrayInt subtitleFormats, int videoBitrate = 6000, bool vbr = false, int audioBitrate = 224) = 0;
	/** Sets pad values */
	void SetPad(const vector<int>& pad);
	/** Sets crop values */
	void SetCrop(const vector<int>& crop);
	/** Sets interlaced encoding flag */
	void SetInterlaced(bool value);
	/** Sets first field flag (Auto, TFF, BFF) */
	void SetFirstField(FirstField firstField);
	/** Starts transcoding. */
	virtual bool Run(bool& canceled) = 0;
	/** Ends ttanscoding and closes all fiies. */
	virtual void End() = 0;
};

#endif // WX_MEDIA_TRANSCODER_H
