/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/
#ifndef PRINTDISCDIALOG_H
#define PRINTDISCDIALOG_H

#include "CommonFunctions.h"

//(*Headers(PrintDiscDialog)
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/spinctrl.h>
#include <wx/statline.h>
#include <wx/panel.h>
#include <wx/choice.h>
#include <wx/button.h>
#include <wx/dialog.h>
//*)

class PrintDiscDialog: public wxDialog
{
	public:

		PrintDiscDialog(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~PrintDiscDialog();

		//(*Declarations(PrintDiscDialog)
		wxStaticText* StaticText9;
		wxButton* Button4;
		wxSpinCtrl* SpinCtrl1;
		wxStaticText* StaticText2;
		wxButton* Button1;
		wxStaticText* StaticText6;
		wxStaticText* StaticText8;
		wxPanel* Panel1;
		wxStaticText* StaticText1;
		wxStaticText* StaticText3;
		wxButton* Button2;
		wxStaticLine* StaticLine2;
		wxButton* Button5;
		wxButton* Button3;
		wxSpinCtrl* SpinCtrl3;
		wxStaticText* StaticText5;
		wxStaticText* StaticText7;
		wxStaticLine* StaticLine1;
		wxSpinCtrl* SpinCtrl2;
		wxPanel* Panel2;
		wxStaticText* StaticText4;
		wxChoice* Choice1;
		//*)

		wxPoint GetPosition() const { return ex_point; }
		int GetSurface() const { return ex_surface; }

	protected:

		//(*Identifiers(PrintDiscDialog)
		static const long ID_PANEL2;
		static const long ID_STATICTEXT1;
		static const long ID_CHOICE1;
		static const long ID_STATICLINE1;
		static const long ID_STATICTEXT2;
		static const long ID_STATICTEXT3;
		static const long ID_SPINCTRL1;
		static const long ID_STATICTEXT5;
		static const long ID_STATICTEXT4;
		static const long ID_SPINCTRL2;
		static const long ID_STATICTEXT6;
		static const long ID_STATICTEXT8;
		static const long ID_SPINCTRL3;
		static const long ID_STATICTEXT9;
		static const long ID_STATICTEXT7;
		static const long ID_BUTTON4;
		static const long ID_BUTTON5;
		static const long ID_STATICLINE2;
		static const long ID_BUTTON1;
		static const long ID_BUTTON2;
		static const long ID_BUTTON3;
		static const long ID_PANEL1;
		//*)

		wxPoint ex_point;
		int ex_surface;

	private:

		//(*Handlers(PrintDiscDialog)
		void OnCancel(wxCommandEvent& event);
		void OnContinue(wxCommandEvent& event);
		void OnHelp(wxCommandEvent& event);
		void OnPrinterModelSelect(wxCommandEvent& event);
		void OnSpinCtrlChange(wxSpinEvent& event);
		void OnPaintPreview(wxPaintEvent& event);
		void OnInit(wxInitDialogEvent& event);
		void NewLayout(wxCommandEvent& event);
		void On_Del_layout(wxCommandEvent& event);
		//*)
		void SaveList();

        CommonFunctions CFs;

        wxString HelpText;

        int DiscPosX, DiscPosY, DiscSurf, CDiscPosX, CDiscPosY, CDiscSurf;

        int MaxModel, SupportedModels, *ModX, *ModY, *ModS;
        wxArrayString ModelNames;

		DECLARE_EVENT_TABLE()
};

#endif
