/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#ifndef MANAGEIMAGESTOREDIALOG_H
#define MANAGEIMAGESTOREDIALOG_H

//(*Headers(ManageImageStoreDialog)
#include <wx/sizer.h>
#include <wx/textctrl.h>
#include <wx/button.h>
#include <wx/dialog.h>
//*)

class ManageImageStoreDialog: public wxDialog
{
	public:

		ManageImageStoreDialog(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~ManageImageStoreDialog();

		//(*Declarations(ManageImageStoreDialog)
		wxButton* Button1;
		wxButton* Button2;
		wxButton* Button3;
		wxTextCtrl* TextCtrl1;
		//*)

		void SetList(wxString oldlist){ TextCtrl1->SetValue(oldlist); }
		wxString GetList() const { return s_paths; }

	protected:

		//(*Identifiers(ManageImageStoreDialog)
		static const long ID_TEXTCTRL1;
		static const long ID_BUTTON1;
		static const long ID_BUTTON2;
		static const long ID_BUTTON3;
		//*)

		wxString s_paths;

	private:

		//(*Handlers(ManageImageStoreDialog)
		void OnButton2Click(wxCommandEvent& event);
		void OnOK(wxCommandEvent& event);
		void OnAdd(wxCommandEvent& event);
		//*)

		DECLARE_EVENT_TABLE()
};

#endif
