/*
 * Decompiled with CFR 0.152.
 */
package org.commonjukebox.plugins.model;

import org.commonjukebox.plugins.exceptions.PluginSystemException;

public class PluginVersion {
    private int majorNumber;
    private int minorNumber;
    private int revisionNumber;

    private PluginVersion(int majorNumber, int minorVersion, int revisionNumber) {
        this.majorNumber = majorNumber;
        this.minorNumber = minorVersion;
        this.revisionNumber = revisionNumber;
    }

    public static PluginVersion getPluginVersion(String versionString) throws PluginSystemException {
        String[] versionNumbers;
        if (versionString != null && !versionString.trim().equals("") && (versionNumbers = versionString.split("\\.")).length == 3) {
            try {
                return new PluginVersion(Integer.parseInt(versionNumbers[0]), Integer.parseInt(versionNumbers[1]), Integer.parseInt(versionNumbers[2]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PluginSystemException("Incorrect version format: " + versionString);
    }

    public String toString() {
        return Integer.toString(this.majorNumber) + "." + Integer.toString(this.minorNumber) + "." + Integer.toString(this.revisionNumber);
    }

    public boolean higherThan(PluginVersion anotherVersion) {
        return this.majorNumber > anotherVersion.majorNumber || this.majorNumber == anotherVersion.majorNumber && this.minorNumber > anotherVersion.minorNumber || this.majorNumber == anotherVersion.majorNumber && this.minorNumber == anotherVersion.minorNumber && this.revisionNumber > anotherVersion.revisionNumber;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PluginVersion)) {
            return false;
        }
        return this.majorNumber == ((PluginVersion)obj).majorNumber && this.minorNumber == ((PluginVersion)obj).minorNumber && this.revisionNumber == ((PluginVersion)obj).revisionNumber;
    }

    public int getMajorNumber() {
        return this.majorNumber;
    }

    public int getMinorNumber() {
        return this.minorNumber;
    }

    public int getRevisionNumber() {
        return this.revisionNumber;
    }
}

