/*
 * Decompiled with CFR 0.152.
 */
package org.commonjukebox.plugins.jar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.commonjukebox.plugins.exceptions.PluginSystemException;

public class JarUtils {
    public List<URI> getJarsInPath(File path, boolean recursive) {
        if (path == null) {
            return null;
        }
        ArrayList<URI> urls = new ArrayList<URI>();
        File[] filesInDir = path.listFiles();
        if (filesInDir.length == 0) {
            return urls;
        }
        File[] fileArray = filesInDir;
        int n = filesInDir.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory() && recursive) {
                List<URI> childFiles = this.getJarsInPath(f, recursive);
                if (childFiles != null) {
                    urls.addAll(childFiles);
                }
            } else if (f.getAbsolutePath().toUpperCase().endsWith(".JAR")) {
                urls.add(f.toURI());
            }
            ++n2;
        }
        return urls;
    }

    public Manifest getManifestFromJar(URI jarURI) throws PluginSystemException {
        if (jarURI == null) {
            return null;
        }
        ZipInputStream jar = null;
        try {
            jar = new JarInputStream(new FileInputStream(new File(jarURI)));
            Manifest manifest = ((JarInputStream)jar).getManifest();
            return manifest;
        }
        catch (Exception e) {
            throw new PluginSystemException(e);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public InputStream getFileFromJar(URI uriOfJar, String fileName) throws PluginSystemException {
        if (uriOfJar == null) {
            return null;
        }
        try {
            JarFile jar = new JarFile(new File(uriOfJar));
            ZipEntry entry = jar.getEntry(fileName);
            if (entry == null) {
                throw new FileNotFoundException(uriOfJar.toString() + ":" + fileName);
            }
            return jar.getInputStream(entry);
        }
        catch (Exception e) {
            throw new PluginSystemException(e);
        }
    }
}

