/*
 * Decompiled with CFR 0.152.
 */
package org.commonjukebox.plugins.classloader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.commonjukebox.plugins.model.PluginFolder;

class PluginsClassLoader
extends ClassLoader {
    private Map<String, Class<?>> classes = new HashMap();
    private List<URI> jars = new ArrayList<URI>();

    PluginsClassLoader() {
    }

    protected void addJars(PluginFolder pluginFolder) {
        this.jars.addAll(pluginFolder.getJars());
    }

    protected void removeJars(PluginFolder pluginFolder) {
        this.jars.removeAll(pluginFolder.getJars());
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    @Override
    public synchronized Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        if (this.classes.containsKey(className)) {
            return this.classes.get(className);
        }
        byte[] clazzArray = null;
        for (URI jar : this.jars) {
            clazzArray = this.findClassInJar(jar, className);
            if (clazzArray != null) break;
        }
        if (clazzArray == null) {
            return super.findSystemClass(className);
        }
        Class<?> clazz = this.defineClass(className, clazzArray, 0, clazzArray.length);
        if (clazz == null) {
            throw new ClassFormatError();
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        this.classes.put(className, clazz);
        return clazz;
    }

    private byte[] findClassInJar(URI jar, String className) {
        byte[] res;
        block20: {
            ZipFile zipFile = null;
            BufferedInputStream bis = null;
            res = null;
            try {
                try {
                    zipFile = new ZipFile(new File(jar));
                    ZipEntry zipEntry = zipFile.getEntry(String.valueOf(className.replace('.', '/')) + ".class");
                    res = new byte[(int)zipEntry.getSize()];
                    bis = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                    bis.read(res, 0, res.length);
                }
                catch (Exception exception) {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (zipFile == null) break block20;
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException iOException) {}
                }
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return res;
    }
}

