/*
 * Decompiled with CFR 0.152.
 */
package org.commonjukebox.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.commonjukebox.plugins.JarInfoReader;
import org.commonjukebox.plugins.PluginActivation;
import org.commonjukebox.plugins.PluginListeners;
import org.commonjukebox.plugins.PluginSystemLogger;
import org.commonjukebox.plugins.PluginValidator;
import org.commonjukebox.plugins.classloader.ClassLoaderManager;
import org.commonjukebox.plugins.exceptions.InvalidJarException;
import org.commonjukebox.plugins.exceptions.PluginNotDesignedForOSException;
import org.commonjukebox.plugins.exceptions.PluginSystemException;
import org.commonjukebox.plugins.jar.JarValidator;
import org.commonjukebox.plugins.model.Plugin;
import org.commonjukebox.plugins.model.PluginConfiguration;
import org.commonjukebox.plugins.model.PluginFolder;
import org.commonjukebox.plugins.model.PluginInfo;
import org.commonjukebox.plugins.model.PluginRepositoryInformation;

public class PluginsLoader {
    private boolean validatePluginApi;
    private String restrictedPackage;
    private Set<String> pluginTypes;
    private PluginListeners pluginListeners;

    PluginsLoader(PluginListeners pluginListeners, boolean validatePluginApi, String restrictedPackage, Set<String> pluginTypes) {
        this.validatePluginApi = validatePluginApi;
        this.restrictedPackage = restrictedPackage;
        this.pluginTypes = pluginTypes;
        this.pluginListeners = pluginListeners;
    }

    protected boolean loadPlugin(PluginRepositoryInformation pri, PluginFolder pluginFolder) throws PluginSystemException {
        PluginInfo pluginInfo;
        boolean active = false;
        if (this.validatePluginApi(pluginFolder) && (pluginInfo = new JarInfoReader().getPluginInFolder(pluginFolder)) != null) {
            this.validatePluginOS(pluginInfo);
            active = this.loadPlugin(pri, pluginFolder, pluginInfo);
            pluginFolder.setPluginInfo(pluginInfo);
        }
        return active;
    }

    private boolean validatePluginApi(PluginFolder pluginFolder) {
        if (this.validatePluginApi) {
            try {
                new JarValidator().validateJars(pluginFolder, this.restrictedPackage);
            }
            catch (InvalidJarException e) {
                PluginSystemLogger.getLogger().severe("Invalid Jar: " + e.getMessage());
                return false;
            }
            catch (PluginSystemException e) {
                PluginSystemLogger.getLogger().severe("Error validating jars in folder " + pluginFolder.getAbsolutePath() + ": " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    private void validatePluginOS(PluginInfo pluginInfo) throws PluginNotDesignedForOSException {
        if (!this.pluginIsDesignedForCurrentOS(pluginInfo)) {
            throw new PluginNotDesignedForOSException("Plugin " + pluginInfo.getName() + " is designed for OS " + pluginInfo.getPluginOS());
        }
    }

    private boolean loadPlugin(PluginRepositoryInformation pri, PluginFolder pluginFolder, PluginInfo pluginInfo) throws PluginSystemException {
        if (this.pluginAlreadyLoaded(pri, pluginInfo)) {
            if (this.higherVersionPluginAlreadyLoaded(pri, pluginInfo)) {
                PluginSystemLogger.getLogger().info(pluginInfo.getName() + " has a higher version loaded. Skipped");
                return false;
            }
            if (this.sameVersionPluginAlreadyLoaded(pri, pluginInfo)) {
                PluginSystemLogger.getLogger().info(pluginInfo.getName() + " has been already loaded. Skipped");
                return false;
            }
            PluginInfo previousPlugin = pri.getPluginByName(pluginInfo.getName());
            ArrayList<PluginInfo> pluginToUnload = new ArrayList<PluginInfo>();
            pluginToUnload.add(previousPlugin);
            this.pluginListeners.callListenersForInactivePlugin(pluginToUnload);
            PluginSystemLogger.getLogger().info("Unloaded version " + previousPlugin.getVersion() + " of plugin " + pluginInfo.getName());
            PluginSystemLogger.getLogger().info("Loaded version " + pluginInfo.getVersion() + " of plugin " + pluginInfo.getName());
        }
        String pluginType = new PluginValidator().validatePlugin(pluginFolder, pluginInfo, this.pluginTypes);
        pluginInfo.setPluginType(pluginType);
        pluginInfo.setDefaultPluginConfiguration(this.getDefaultPluginConfiguration(pluginFolder, pluginInfo));
        PluginSystemLogger.getLogger().info("Loaded plugin: " + pluginInfo.getName());
        if (PluginActivation.isPluginActive(pluginInfo)) {
            pluginInfo.setActive(true);
            PluginSystemLogger.getLogger().fine(pluginInfo.getName() + " is active");
            return true;
        }
        return false;
    }

    private PluginConfiguration getDefaultPluginConfiguration(PluginFolder pluginFolder, PluginInfo pluginInfo) throws PluginSystemException {
        ClassLoaderManager classLoaderManager = new ClassLoaderManager();
        try {
            classLoaderManager.addToClassLoader(Collections.singleton(pluginFolder));
            Class<?> c = classLoaderManager.loadClass(pluginInfo.getClassName());
            PluginConfiguration pluginConfiguration = ((Plugin)c.newInstance()).getDefaultConfiguration();
            return pluginConfiguration;
        }
        catch (Throwable e) {
            throw new PluginSystemException(e);
        }
        finally {
            classLoaderManager.removeFromClassLoader(Collections.singleton(pluginFolder));
        }
    }

    private boolean pluginIsDesignedForCurrentOS(PluginInfo pluginInfo) {
        return pluginInfo.getPluginOS() == null || System.getProperty("os.name").equalsIgnoreCase(pluginInfo.getPluginOS());
    }

    private boolean pluginAlreadyLoaded(PluginRepositoryInformation pri, PluginInfo pluginInfo) {
        return pri.getPluginNames().contains(pluginInfo.getName());
    }

    private boolean higherVersionPluginAlreadyLoaded(PluginRepositoryInformation pri, PluginInfo pluginInfo) {
        return this.pluginAlreadyLoaded(pri, pluginInfo) && pri.getPluginByName(pluginInfo.getName()).getVersion().higherThan(pluginInfo.getVersion());
    }

    private boolean sameVersionPluginAlreadyLoaded(PluginRepositoryInformation pri, PluginInfo pluginInfo) {
        return this.pluginAlreadyLoaded(pri, pluginInfo) && pri.getPluginByName(pluginInfo.getName()).getVersion().equals(pluginInfo.getVersion());
    }
}

