/*
 * Decompiled with CFR 0.152.
 */
package org.commonjukebox.plugins;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import org.commonjukebox.plugins.classloader.ClassLoaderManager;
import org.commonjukebox.plugins.exceptions.InvalidPluginException;
import org.commonjukebox.plugins.exceptions.PluginSystemException;
import org.commonjukebox.plugins.model.Plugin;
import org.commonjukebox.plugins.model.PluginFolder;
import org.commonjukebox.plugins.model.PluginInfo;

class PluginValidator {
    PluginValidator() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String validatePlugin(PluginFolder pluginFolder, PluginInfo pluginInfo, Set<String> pluginTypes) throws PluginSystemException {
        if (pluginInfo.getClassName() == null) {
            throw new InvalidPluginException("Null class name for plugin");
        }
        ClassLoaderManager classLoaderManager = new ClassLoaderManager();
        try {
            classLoaderManager.addToClassLoader(Collections.singleton(pluginFolder));
            Class<?> c = classLoaderManager.loadClass(pluginInfo.getClassName());
            boolean pluginInterfaceImplemented = this.implementsInterface(c, Plugin.class.getName());
            if (!pluginInterfaceImplemented) {
                Class<?> superClass = c.getSuperclass();
                while (!pluginInterfaceImplemented && superClass != Object.class) {
                    if (this.implementsInterface(superClass, Plugin.class.getName())) {
                        pluginInterfaceImplemented = true;
                        continue;
                    }
                    superClass = superClass.getSuperclass();
                }
            }
            if (!pluginInterfaceImplemented) throw new InvalidPluginException(String.valueOf(pluginInfo.getClassName()) + " is not a valid plugin");
            for (String pluginType : pluginTypes) {
                if (this.implementsInterface(c, pluginType) || this.extendsClass(c, pluginType)) {
                    String string = pluginType;
                    return string;
                }
                Class<?> superClass = c.getSuperclass();
                while (superClass != Object.class) {
                    if (this.implementsInterface(superClass, pluginType) || this.extendsClass(superClass, pluginType)) {
                        String string = pluginType;
                        return string;
                    }
                    superClass = superClass.getSuperclass();
                }
            }
            {
                throw new InvalidPluginException(String.valueOf(pluginInfo.getClassName()) + " is not a valid plugin");
            }
        }
        catch (InvalidPluginException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvalidPluginException(e);
        }
        finally {
            classLoaderManager.removeFromClassLoader(Collections.singleton(pluginFolder));
        }
    }

    private boolean implementsInterface(Class<?> clazz, String interfaceName) {
        Type[] interfaces;
        Type[] typeArray = interfaces = clazz.getGenericInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Type t = typeArray[n2];
            String interfaceImplemented = t.toString().replace("interface ", "");
            if (interfaceName.equals(interfaceImplemented)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean extendsClass(Class<?> clazz, String superClass) {
        Type superClassExtended = clazz.getGenericSuperclass();
        String classExtended = superClassExtended.toString().replace("class ", "");
        return superClass.equals(classExtended);
    }
}

