/*
 * Decompiled with CFR 0.152.
 */
package org.commonjukebox.plugins;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.commonjukebox.plugins.PluginSystemLogger;
import org.commonjukebox.plugins.exceptions.PluginSystemException;
import org.commonjukebox.plugins.model.PluginFolder;
import org.commonjukebox.plugins.model.PluginInfo;
import org.commonjukebox.plugins.model.PluginListener;

public class PluginListeners
extends HashMap<String, Set<PluginListener>> {
    private static final long serialVersionUID = 3832021951188703168L;

    protected void addPluginListener(String pluginType, PluginListener listener) {
        if (!this.containsKey(pluginType)) {
            this.put(pluginType, new HashSet());
        }
        ((Set)this.get(pluginType)).add(listener);
    }

    protected void callListenersForActivePlugin(Collection<PluginFolder> pluginFolders) throws PluginSystemException {
        for (PluginFolder pluginFolder : pluginFolders) {
            PluginInfo pluginMetadata = pluginFolder.getPluginInfo();
            this.callListenersForActivePlugin(pluginMetadata);
        }
    }

    protected void callListenersForActivePlugin(PluginInfo pluginMetadata) throws PluginSystemException {
        if (this.containsKey(pluginMetadata.getPluginType())) {
            Set pluginListeners = (Set)this.get(pluginMetadata.getPluginType());
            for (PluginListener pluginListener : pluginListeners) {
                try {
                    PluginSystemLogger.getLogger().fine("Calling listener: " + pluginListener.getClass().getName());
                    pluginListener.pluginActivated(pluginMetadata);
                }
                catch (Exception e) {
                    throw new PluginSystemException("Exception activating plugin: " + pluginMetadata.getName(), e);
                }
                catch (Error e) {
                    throw new PluginSystemException("Error activating plugin: " + pluginMetadata.getName(), e);
                }
            }
        }
    }

    protected void callListenersForInactivePlugin(Collection<PluginInfo> plugins) throws PluginSystemException {
        for (PluginInfo plugin : plugins) {
            if (!this.containsKey(plugin.getPluginType())) continue;
            Set pluginListeners = (Set)this.get(plugin.getPluginType());
            for (PluginListener pluginListener : pluginListeners) {
                try {
                    PluginSystemLogger.getLogger().fine("Calling listener: " + pluginListener.getClass().getName());
                    pluginListener.pluginDeactivated(plugin, plugin.getInstancedObjects());
                }
                catch (Exception e) {
                    throw new PluginSystemException("Exception deactivating plugin: " + plugin.getName(), e);
                }
                catch (Error e) {
                    throw new PluginSystemException("Error deactivating plugin: " + plugin.getName(), e);
                }
            }
        }
    }
}

