/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.media;

import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.gstreamer.Bus;
import org.gstreamer.ClockTime;
import org.gstreamer.Format;
import org.gstreamer.Gst;
import org.gstreamer.GstObject;
import org.gstreamer.Pipeline;
import org.gstreamer.State;
import org.gstreamer.media.AbstractMediaPlayer;
import org.gstreamer.media.event.DurationChangedEvent;
import org.gstreamer.media.event.EndOfMediaEvent;
import org.gstreamer.media.event.MediaListener;
import org.gstreamer.media.event.PauseEvent;
import org.gstreamer.media.event.PositionChangedEvent;
import org.gstreamer.media.event.StartEvent;
import org.gstreamer.media.event.StopEvent;

public abstract class PipelineMediaPlayer
extends AbstractMediaPlayer {
    protected final Pipeline pipeline;
    private volatile ScheduledFuture<?> positionTimer = null;
    protected volatile State currentState = State.NULL;
    private Runnable positionUpdater = new Runnable(){
        private long lastPosition = 0L;
        private ClockTime lastDuration = ClockTime.ZERO;

        public void run() {
            long position = PipelineMediaPlayer.this.pipeline.queryPosition(Format.TIME);
            long percent = PipelineMediaPlayer.this.pipeline.queryPosition(Format.PERCENT);
            ClockTime duration = PipelineMediaPlayer.this.pipeline.queryDuration();
            boolean durationChanged = !duration.equals(this.lastDuration) && !duration.equals(ClockTime.ZERO) && !duration.equals(ClockTime.NONE);
            this.lastDuration = duration;
            boolean positionChanged = position != this.lastPosition && position >= 0L;
            this.lastPosition = position;
            PositionChangedEvent pue = new PositionChangedEvent(PipelineMediaPlayer.this, ClockTime.valueOf(position, TimeUnit.NANOSECONDS), (int)percent);
            DurationChangedEvent due = new DurationChangedEvent(PipelineMediaPlayer.this, duration);
            for (MediaListener l : PipelineMediaPlayer.this.getMediaListeners()) {
                if (durationChanged) {
                    l.durationChanged(due);
                }
                if (!positionChanged) continue;
                l.positionChanged(pue);
            }
        }
    };
    private Bus.EOS eosSignal = new Bus.EOS(){

        public void endOfStream(GstObject source) {
            URI next = (URI)PipelineMediaPlayer.this.playList.poll();
            if (next != null) {
                PipelineMediaPlayer.this.setURI(next);
            } else {
                EndOfMediaEvent evt = new EndOfMediaEvent(PipelineMediaPlayer.this, State.PLAYING, State.NULL, State.VOID_PENDING);
                PipelineMediaPlayer.this.fireEndOfMediaEvent(evt);
            }
        }
    };
    private final Bus.STATE_CHANGED stateChanged = new Bus.STATE_CHANGED(){

        public void stateChanged(GstObject source, State old, State newState, State pending) {
            ClockTime position = PipelineMediaPlayer.this.getPipeline().queryPosition();
            switch (newState) {
                case PLAYING: {
                    if (PipelineMediaPlayer.this.currentState != State.NULL && PipelineMediaPlayer.this.currentState != State.PAUSED) break;
                    PipelineMediaPlayer.this.fireStartEvent(new StartEvent(PipelineMediaPlayer.this, PipelineMediaPlayer.this.currentState, newState, State.VOID_PENDING, position));
                    PipelineMediaPlayer.this.currentState = State.PLAYING;
                    break;
                }
                case PAUSED: {
                    if (PipelineMediaPlayer.this.currentState != State.PLAYING) break;
                    PipelineMediaPlayer.this.firePauseEvent(new PauseEvent(PipelineMediaPlayer.this, PipelineMediaPlayer.this.currentState, newState, State.VOID_PENDING, position));
                    PipelineMediaPlayer.this.currentState = State.PAUSED;
                    break;
                }
                case NULL: 
                case READY: {
                    if (PipelineMediaPlayer.this.currentState != State.PLAYING) break;
                    PipelineMediaPlayer.this.fireStopEvent(new StopEvent(PipelineMediaPlayer.this, PipelineMediaPlayer.this.currentState, newState, State.VOID_PENDING, position));
                }
            }
        }
    };

    protected PipelineMediaPlayer(Pipeline pipeline, Executor executor) {
        super(executor);
        this.pipeline = pipeline;
        this.getPipeline().getBus().connect(this.eosSignal);
        this.getPipeline().getBus().connect(this.stateChanged);
    }

    public synchronized void addMediaListener(MediaListener listener) {
        if (this.getMediaListeners().isEmpty()) {
            this.positionTimer = Gst.getScheduledExecutorService().scheduleAtFixedRate(this.positionUpdater, 1L, 1L, TimeUnit.SECONDS);
        }
        super.addMediaListener(listener);
    }

    public synchronized void removeMediaListener(MediaListener listener) {
        super.removeMediaListener(listener);
        if (this.getMediaListeners().isEmpty() && this.positionTimer != null) {
            this.positionTimer.cancel(true);
            this.positionTimer = null;
        }
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }
}

