/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.File;
import org.gstreamer.Element;
import org.gstreamer.GstException;
import org.gstreamer.GstObject;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.GstObjectAPI;

public class GstXML {
    private static final GstXMLAPI gst = GstNative.load(GstXMLAPI.class);
    private final File file;

    public GstXML(File file) {
        this.file = file;
    }

    public Element loadElement(String elementName) {
        GstObject xml = gst.gst_xml_new();
        if (!gst.gst_xml_parse_file(xml, this.file.getAbsolutePath(), null)) {
            throw new GstException("Could not parse " + this.file);
        }
        Element element = gst.gst_xml_get_element(xml, elementName);
        if (element == null) {
            throw new GstException("Could not load " + elementName);
        }
        return element;
    }

    public void saveElement(Element element) {
        Pointer fp = LibC.INSTANCE.fopen(this.file.getAbsolutePath(), "w");
        if (fp == null) {
            throw new GstException("Could not open " + this.file + " [errno=" + Native.getLastError() + "]");
        }
        gst.gst_xml_write_file(element, fp);
        LibC.INSTANCE.fclose(fp);
    }

    private static interface GstXMLAPI
    extends GstObjectAPI {
        public GstObject gst_xml_new();

        public int gst_xml_write_file(Element var1, Pointer var2);

        public boolean gst_xml_parse_file(GstObject var1, String var2, String var3);

        public Element gst_xml_get_element(GstObject var1, String var2);
    }

    private static interface LibC
    extends Library {
        public static final LibC INSTANCE = (LibC)Native.loadLibrary((String)"c", LibC.class);

        public Pointer fopen(String var1, String var2);

        public int fclose(Pointer var1);
    }
}

