/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.valuepair;

import java.util.HashMap;
import java.util.Map;

public class ImageFormats {
    public static final String V22_JPG_FORMAT = "JPG";
    public static final String V22_PNG_FORMAT = "PNG";
    public static final String V22_GIF_FORMAT = "GIF";
    public static final String V22_BMP_FORMAT = "BMP";
    public static final String V22_TIF_FORMAT = "TIF";
    public static final String V22_PDF_FORMAT = "PDF";
    public static final String V22_PIC_FORMAT = "PIC";
    public static final String MIME_TYPE_JPEG = "image/jpeg";
    public static final String MIME_TYPE_PNG = "image/png";
    public static final String MIME_TYPE_GIF = "image/gif";
    public static final String MIME_TYPE_BMP = "image/bmp";
    public static final String MIME_TYPE_TIFF = "image/tiff";
    public static final String MIME_TYPE_PDF = "image/pdf";
    public static final String MIME_TYPE_PICT = "image/x-pict";
    public static final String MIME_TYPE_JPG = "image/jpg";
    private static Map<String, String> imageFormatsToMimeType = new HashMap<String, String>();
    private static Map<String, String> imageMimeTypeToFormat = new HashMap<String, String>();

    public static String getMimeTypeForFormat(String format) {
        return imageFormatsToMimeType.get(format);
    }

    public static String getFormatForMimeType(String mimeType) {
        return imageMimeTypeToFormat.get(mimeType);
    }

    public static boolean binaryDataIsPngFormat(byte[] data) {
        return 137 == (data[0] & 0xFF) && 80 == (data[1] & 0xFF) && 78 == (data[2] & 0xFF) && 71 == (data[3] & 0xFF);
    }

    public static boolean binaryDataIsJpgFormat(byte[] data) {
        return 255 == (data[0] & 0xFF) && 216 == (data[1] & 0xFF) && 255 == (data[2] & 0xFF) && 224 <= (data[3] & 0xFF);
    }

    public static boolean binaryDataIsGifFormat(byte[] data) {
        return 71 == (data[0] & 0xFF) && 73 == (data[1] & 0xFF) && 70 == (data[2] & 0xFF);
    }

    public static boolean binaryDataIsBmpFormat(byte[] data) {
        return 66 == (data[0] & 0xFF) && 77 == (data[1] & 0xFF);
    }

    public static boolean binaryDataIsPdfFormat(byte[] data) {
        return 37 == (data[0] & 0xFF) && 80 == (data[1] & 0xFF) && 68 == (data[2] & 0xFF) && 70 == (data[3] & 0xFF);
    }

    public static boolean binaryDataIsTiffFormat(byte[] data) {
        return 73 == (data[0] & 0xFF) && 73 == (data[1] & 0xFF) && 42 == (data[2] & 0xFF) && 0 == (data[3] & 0xFF) || 77 == (data[0] & 0xFF) && 77 == (data[1] & 0xFF) && 0 == (data[2] & 0xFF) && 42 == (data[3] & 0xFF);
    }

    public static boolean isPortableFormat(byte[] data) {
        return ImageFormats.binaryDataIsPngFormat(data) || ImageFormats.binaryDataIsJpgFormat(data) || ImageFormats.binaryDataIsGifFormat(data);
    }

    public static String getMimeTypeForBinarySignature(byte[] data) {
        if (ImageFormats.binaryDataIsPngFormat(data)) {
            return MIME_TYPE_PNG;
        }
        if (ImageFormats.binaryDataIsJpgFormat(data)) {
            return MIME_TYPE_JPEG;
        }
        if (ImageFormats.binaryDataIsGifFormat(data)) {
            return MIME_TYPE_GIF;
        }
        if (ImageFormats.binaryDataIsBmpFormat(data)) {
            return MIME_TYPE_BMP;
        }
        if (ImageFormats.binaryDataIsPdfFormat(data)) {
            return MIME_TYPE_PDF;
        }
        if (ImageFormats.binaryDataIsTiffFormat(data)) {
            return MIME_TYPE_TIFF;
        }
        return null;
    }

    static {
        imageFormatsToMimeType.put(V22_JPG_FORMAT, MIME_TYPE_JPEG);
        imageFormatsToMimeType.put(V22_PNG_FORMAT, MIME_TYPE_PNG);
        imageFormatsToMimeType.put(V22_GIF_FORMAT, MIME_TYPE_GIF);
        imageFormatsToMimeType.put(V22_BMP_FORMAT, MIME_TYPE_BMP);
        imageFormatsToMimeType.put(V22_TIF_FORMAT, MIME_TYPE_TIFF);
        imageFormatsToMimeType.put(V22_PDF_FORMAT, MIME_TYPE_PDF);
        imageFormatsToMimeType.put(V22_PIC_FORMAT, MIME_TYPE_PICT);
        for (String key : imageFormatsToMimeType.keySet()) {
            String value = imageFormatsToMimeType.get(key);
            imageMimeTypeToFormat.put(value, key);
        }
        imageMimeTypeToFormat.put(MIME_TYPE_JPG, V22_JPG_FORMAT);
    }
}

