/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import org.jaudiotagger.tag.id3.Id3FieldType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ID3v24FieldKey {
    ARTIST("TPE1", Id3FieldType.TEXT),
    ALBUM("TALB", Id3FieldType.TEXT),
    TITLE("TIT2", Id3FieldType.TEXT),
    TRACK("TRCK", Id3FieldType.TEXT),
    YEAR("TDRC", Id3FieldType.TEXT),
    GENRE("TCON", Id3FieldType.TEXT),
    COMMENT("COMM", Id3FieldType.TEXT),
    ALBUM_ARTIST("TPE2", Id3FieldType.TEXT),
    COMPOSER("TCOM", Id3FieldType.TEXT),
    GROUPING("TIT1", Id3FieldType.TEXT),
    DISC_NO("TPOS", Id3FieldType.TEXT),
    BPM("TBPM", Id3FieldType.TEXT),
    ENCODER("TENC", Id3FieldType.TEXT),
    MUSICBRAINZ_ARTISTID("TXXX", "MusicBrainz Artist Id", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASEID("TXXX", "MusicBrainz Album Id", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASEARTISTID("TXXX", "MusicBrainz Album Artist Id", Id3FieldType.TEXT),
    MUSICBRAINZ_TRACK_ID("UFID", "http://musicbrainz.org", Id3FieldType.TEXT),
    MUSICBRAINZ_DISC_ID("TXXX", "MusicBrainz Disc Id", Id3FieldType.TEXT),
    MUSICIP_ID("TXXX", "MusicIP PUID", Id3FieldType.TEXT),
    AMAZON_ID("TXXX", "ASIN", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASE_STATUS("TXXX", "MusicBrainz Album Status", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASE_TYPE("TXXX", "MusicBrainz Album Type", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASE_COUNTRY("TXXX", "MusicBrainz Album Release Country", Id3FieldType.TEXT),
    LYRICS("USLT", Id3FieldType.TEXT),
    IS_COMPILATION("TCMP", Id3FieldType.TEXT),
    ARTIST_SORT("TSOP", Id3FieldType.TEXT),
    ALBUM_ARTIST_SORT("TSO2", Id3FieldType.TEXT),
    ALBUM_SORT("TSOA", Id3FieldType.TEXT),
    TITLE_SORT("TSOT", Id3FieldType.TEXT),
    COMPOSER_SORT("TSOC", Id3FieldType.TEXT),
    COVER_ART("APIC", Id3FieldType.BINARY),
    ISRC("TSRC", Id3FieldType.TEXT),
    BARCODE("TXXX", "BARCODE", Id3FieldType.TEXT),
    CATALOG_NO("TXXX", "CATALOGNUMBER", Id3FieldType.TEXT),
    RECORD_LABEL("TPUB", Id3FieldType.TEXT),
    LYRICIST("TEXT", Id3FieldType.TEXT),
    CONDUCTOR("TPE3", Id3FieldType.TEXT),
    REMIXER("TPE4", Id3FieldType.TEXT),
    MOOD("TMOO", Id3FieldType.TEXT),
    MEDIA("TMED", Id3FieldType.TEXT),
    URL_OFFICIAL_RELEASE_SITE("WXXX", "OFFICIAL_RELEASE", Id3FieldType.TEXT),
    URL_DISCOGS_RELEASE_SITE("WXXX", "DISCOGS_RELEASE", Id3FieldType.TEXT),
    URL_WIKIPEDIA_RELEASE_SITE("WXXX", "WIKIPEDIA_RELEASE", Id3FieldType.TEXT),
    URL_OFFICIAL_ARTIST_SITE("WOAR", Id3FieldType.TEXT),
    URL_DISCOGS_ARTIST_SITE("WXXX", "DISCOGS_ARTIST", Id3FieldType.TEXT),
    URL_WIKIPEDIA_ARTIST_SITE("WXXX", "WIKIPEDIA_ARTIST", Id3FieldType.TEXT),
    LANGUAGE("TLAN", Id3FieldType.TEXT),
    KEY("TKEY", Id3FieldType.TEXT),
    URL_LYRICS_SITE("WXXX", "LYRICS_SITE", Id3FieldType.TEXT),
    DISC_TOTAL("TPOS", Id3FieldType.TEXT),
    TRACK_TOTAL("TRCK", Id3FieldType.TEXT);

    private String fieldName;
    private String frameId;
    private String subId;
    private Id3FieldType fieldType;

    private ID3v24FieldKey(String frameId, Id3FieldType fieldType) {
        this.frameId = frameId;
        this.fieldType = fieldType;
        this.fieldName = frameId;
    }

    private ID3v24FieldKey(String frameId, String subId, Id3FieldType fieldType) {
        this.frameId = frameId;
        this.subId = subId;
        this.fieldType = fieldType;
        this.fieldName = frameId + ":" + subId;
    }

    public Id3FieldType getFieldType() {
        return this.fieldType;
    }

    public String getFrameId() {
        return this.frameId;
    }

    public String getSubId() {
        return this.subId;
    }

    public String getFieldName() {
        return this.fieldName;
    }
}

