/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.EmptyFrameException;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.InvalidFrameIdentifierException;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagNotFoundException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.datatype.Artwork;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.ID3Frames;
import org.jaudiotagger.tag.id3.ID3SyncSafeInteger;
import org.jaudiotagger.tag.id3.ID3Unsynchronization;
import org.jaudiotagger.tag.id3.ID3v22FieldKey;
import org.jaudiotagger.tag.id3.ID3v22Frame;
import org.jaudiotagger.tag.id3.ID3v22Frames;
import org.jaudiotagger.tag.id3.ID3v22PreferredFrameOrderComparator;
import org.jaudiotagger.tag.id3.ID3v23Tag;
import org.jaudiotagger.tag.id3.ID3v24Tag;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyTextInfo;
import org.jaudiotagger.tag.id3.framebody.FrameBodyPIC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDRC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPOS;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTRCK;
import org.jaudiotagger.tag.id3.valuepair.ImageFormats;
import org.jaudiotagger.tag.reference.PictureTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ID3v22Tag
extends AbstractID3v2Tag {
    protected static final String TYPE_COMPRESSION = "compression";
    protected static final String TYPE_UNSYNCHRONISATION = "unsyncronisation";
    public static final int MASK_V22_UNSYNCHRONIZATION = 128;
    public static final int MASK_V22_COMPRESSION = 64;
    protected boolean compression = false;
    protected boolean unsynchronization = false;
    public static final byte RELEASE = 2;
    public static final byte MAJOR_VERSION = 2;
    public static final byte REVISION = 0;

    @Override
    public byte getRelease() {
        return 2;
    }

    @Override
    public byte getMajorVersion() {
        return 2;
    }

    @Override
    public byte getRevision() {
        return 0;
    }

    public ID3v22Tag() {
        this.frameMap = new LinkedHashMap();
        this.encryptedFrameMap = new LinkedHashMap();
    }

    @Override
    protected void copyPrimitives(AbstractID3v2Tag copyObj) {
        logger.info("Copying primitives");
        super.copyPrimitives(copyObj);
        if (copyObj instanceof ID3v22Tag) {
            ID3v22Tag copyObject = (ID3v22Tag)copyObj;
            this.compression = copyObject.compression;
            this.unsynchronization = copyObject.unsynchronization;
        } else if (copyObj instanceof ID3v23Tag) {
            ID3v23Tag copyObject = (ID3v23Tag)copyObj;
            this.compression = copyObject.compression;
            this.unsynchronization = copyObject.unsynchronization;
        } else if (copyObj instanceof ID3v24Tag) {
            ID3v24Tag copyObject = (ID3v24Tag)copyObj;
            this.compression = false;
            this.unsynchronization = copyObject.unsynchronization;
        }
    }

    public ID3v22Tag(ID3v22Tag copyObject) {
        super(copyObject);
        logger.info("Creating tag from another tag of same type");
        this.copyPrimitives(copyObject);
        this.copyFrames(copyObject);
    }

    public ID3v22Tag(AbstractTag mp3tag) {
        this.frameMap = new LinkedHashMap();
        this.encryptedFrameMap = new LinkedHashMap();
        logger.info("Creating tag from a tag of a different version");
        if (mp3tag != null) {
            if (!(mp3tag instanceof ID3v23Tag) && mp3tag instanceof ID3v22Tag) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            ID3v24Tag convertedTag = mp3tag instanceof ID3v24Tag ? (ID3v24Tag)mp3tag : new ID3v24Tag(mp3tag);
            this.copyPrimitives(convertedTag);
            this.copyFrames(convertedTag);
            logger.info("Created tag from a tag of a different version");
        }
    }

    public ID3v22Tag(ByteBuffer buffer, String loggingFilename) throws TagException {
        this.setLoggingFilename(loggingFilename);
        this.read(buffer);
    }

    public ID3v22Tag(ByteBuffer buffer) throws TagException {
        this(buffer, "");
    }

    @Override
    public String getIdentifier() {
        return "ID3v2_2.20";
    }

    @Override
    public int getSize() {
        int size = 10;
        return size += super.getSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v22Tag)) {
            return false;
        }
        ID3v22Tag object = (ID3v22Tag)obj;
        if (this.compression != object.compression) {
            return false;
        }
        return this.unsynchronization == object.unsynchronization && super.equals(obj);
    }

    @Override
    protected void addFrame(AbstractID3v2Frame frame) {
        try {
            if (frame.getIdentifier().equals("TDRC") && frame.getBody() instanceof FrameBodyTDRC) {
                this.translateFrame(frame);
            } else if (frame instanceof ID3v22Frame) {
                this.copyFrameIntoMap(frame.getIdentifier(), frame);
            } else {
                ID3v22Frame newFrame = new ID3v22Frame(frame);
                this.copyFrameIntoMap(newFrame.getIdentifier(), newFrame);
            }
        }
        catch (InvalidFrameException ife) {
            logger.log(Level.SEVERE, "Unable to convert frame:" + frame.getIdentifier());
        }
    }

    public int readSize(ByteBuffer buffer) {
        byte flags = buffer.get();
        int size = ID3SyncSafeInteger.bufferToValue(buffer);
        return size + 10;
    }

    private void readHeaderFlags(ByteBuffer byteBuffer) throws TagException {
        byte flags = byteBuffer.get();
        this.unsynchronization = (flags & 0x80) != 0;
        boolean bl = this.compression = (flags & 0x40) != 0;
        if (this.unsynchronization) {
            logger.info(ErrorMessage.ID3_TAG_UNSYNCHRONIZED.getMsg(this.getLoggingFilename()));
        }
        if (this.compression) {
            logger.info(ErrorMessage.ID3_TAG_COMPRESSED.getMsg(this.getLoggingFilename()));
        }
        if ((flags & 0x20) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 32));
        }
        if ((flags & 0x10) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 16));
        }
        if ((flags & 8) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 8));
        }
        if ((flags & 4) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 4));
        }
        if ((flags & 2) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 2));
        }
        if ((flags & 1) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 8));
        }
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws TagException {
        if (!this.seek(byteBuffer)) {
            throw new TagNotFoundException("ID3v2.20 tag not found");
        }
        logger.info(this.getLoggingFilename() + ":" + "Reading tag from file");
        this.readHeaderFlags(byteBuffer);
        int size = ID3SyncSafeInteger.bufferToValue(byteBuffer);
        ByteBuffer bufferWithoutHeader = byteBuffer.slice();
        if (this.unsynchronization) {
            bufferWithoutHeader = ID3Unsynchronization.synchronize(bufferWithoutHeader);
        }
        this.readFrames(bufferWithoutHeader, size);
        logger.info(this.getLoggingFilename() + ":" + "Loaded Frames,there are:" + this.frameMap.keySet().size());
    }

    protected void readFrames(ByteBuffer byteBuffer, int size) {
        this.frameMap = new LinkedHashMap();
        this.encryptedFrameMap = new LinkedHashMap();
        this.fileReadSize = size;
        logger.finest(this.getLoggingFilename() + ":" + "Start of frame body at:" + byteBuffer.position() + ",frames sizes and padding is:" + size);
        while (byteBuffer.position() < size) {
            try {
                logger.finest(this.getLoggingFilename() + ":" + "looking for next frame at:" + byteBuffer.position());
                ID3v22Frame next = new ID3v22Frame(byteBuffer, this.getLoggingFilename());
                String id = next.getIdentifier();
                this.loadFrameIntoMap(id, next);
            }
            catch (EmptyFrameException ex) {
                logger.warning(this.getLoggingFilename() + ":" + "Empty Frame:" + ex.getMessage());
                this.emptyFrameBytes += 6;
            }
            catch (InvalidFrameIdentifierException ifie) {
                logger.info(this.getLoggingFilename() + ":" + "Invalid Frame Identifier:" + ifie.getMessage());
                ++this.invalidFrames;
                break;
            }
            catch (InvalidFrameException ife) {
                logger.warning(this.getLoggingFilename() + ":" + "Invalid Frame:" + ife.getMessage());
                ++this.invalidFrames;
                break;
            }
            catch (InvalidDataTypeException idete) {
                logger.warning(this.getLoggingFilename() + ":Corrupt Frame:" + idete.getMessage());
                ++this.invalidFrames;
            }
        }
    }

    protected void translateFrame(AbstractID3v2Frame frame) {
        ID3v22Frame newFrame;
        FrameBodyTDRC tmpBody = (FrameBodyTDRC)frame.getBody();
        if (tmpBody.getYear().length() != 0) {
            newFrame = new ID3v22Frame("TYE");
            ((AbstractFrameBodyTextInfo)newFrame.getBody()).setText(tmpBody.getYear());
            this.frameMap.put(newFrame.getIdentifier(), newFrame);
        }
        if (tmpBody.getTime().length() != 0) {
            newFrame = new ID3v22Frame("TIM");
            ((AbstractFrameBodyTextInfo)newFrame.getBody()).setText(tmpBody.getTime());
            this.frameMap.put(newFrame.getIdentifier(), newFrame);
        }
    }

    private ByteBuffer writeHeaderToBuffer(int padding, int size) throws IOException {
        this.compression = false;
        ByteBuffer headerBuffer = ByteBuffer.allocate(10);
        headerBuffer.put(TAG_ID);
        headerBuffer.put(this.getMajorVersion());
        headerBuffer.put(this.getRevision());
        byte flags = 0;
        if (this.unsynchronization) {
            flags = (byte)(flags | 0xFFFFFF80);
        }
        if (this.compression) {
            flags = (byte)(flags | 0x40);
        }
        headerBuffer.put(flags);
        headerBuffer.put(ID3SyncSafeInteger.valueToBuffer(padding + size));
        headerBuffer.flip();
        return headerBuffer;
    }

    @Override
    public void write(File file, long audioStartLocation) throws IOException {
        logger.info("Writing tag to file");
        byte[] bodyByteBuffer = this.writeFramesToBuffer().toByteArray();
        boolean bl = this.unsynchronization = TagOptionSingleton.getInstance().isUnsyncTags() && ID3Unsynchronization.requiresUnsynchronization(bodyByteBuffer);
        if (this.isUnsynchronization()) {
            bodyByteBuffer = ID3Unsynchronization.unsynchronize(bodyByteBuffer);
            logger.info(this.getLoggingFilename() + ":bodybytebuffer:sizeafterunsynchronisation:" + bodyByteBuffer.length);
        }
        int sizeIncPadding = this.calculateTagSize(bodyByteBuffer.length + 10, (int)audioStartLocation);
        int padding = sizeIncPadding - (bodyByteBuffer.length + 10);
        logger.info(this.getLoggingFilename() + ":Current audiostart:" + audioStartLocation);
        logger.info(this.getLoggingFilename() + ":Size including padding:" + sizeIncPadding);
        logger.info(this.getLoggingFilename() + ":Padding:" + padding);
        ByteBuffer headerBuffer = this.writeHeaderToBuffer(padding, bodyByteBuffer.length);
        this.writeBufferToFile(file, headerBuffer, bodyByteBuffer, padding, sizeIncPadding, audioStartLocation);
    }

    @Override
    public void write(WritableByteChannel channel) throws IOException {
        logger.info(this.getLoggingFilename() + ":Writing tag to channel");
        byte[] bodyByteBuffer = this.writeFramesToBuffer().toByteArray();
        logger.info(this.getLoggingFilename() + ":bodybytebuffer:sizebeforeunsynchronisation:" + bodyByteBuffer.length);
        boolean bl = this.unsynchronization = TagOptionSingleton.getInstance().isUnsyncTags() && ID3Unsynchronization.requiresUnsynchronization(bodyByteBuffer);
        if (this.isUnsynchronization()) {
            bodyByteBuffer = ID3Unsynchronization.unsynchronize(bodyByteBuffer);
            logger.info(this.getLoggingFilename() + ":bodybytebuffer:sizeafterunsynchronisation:" + bodyByteBuffer.length);
        }
        ByteBuffer headerBuffer = this.writeHeaderToBuffer(0, bodyByteBuffer.length);
        channel.write(headerBuffer);
        channel.write(ByteBuffer.wrap(bodyByteBuffer));
    }

    @Override
    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("tag", this.getIdentifier());
        super.createStructureHeader();
        MP3File.getStructureFormatter().openHeadingElement("header", "");
        MP3File.getStructureFormatter().addElement(TYPE_COMPRESSION, this.compression);
        MP3File.getStructureFormatter().addElement(TYPE_UNSYNCHRONISATION, this.unsynchronization);
        MP3File.getStructureFormatter().closeHeadingElement("header");
        super.createStructureBody();
        MP3File.getStructureFormatter().closeHeadingElement("tag");
    }

    public boolean isUnsynchronization() {
        return this.unsynchronization;
    }

    public boolean isCompression() {
        return this.compression;
    }

    @Override
    public ID3v22Frame createFrame(String id) {
        return new ID3v22Frame(id);
    }

    public TagField createField(ID3v22FieldKey id3Key, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (id3Key == null) {
            throw new KeyNotFoundException();
        }
        return super.doCreateTagField(new AbstractID3v2Tag.FrameAndSubId(id3Key.getFrameId(), id3Key.getSubId()), value);
    }

    public String getFirst(ID3v22FieldKey id3v22FieldKey) throws KeyNotFoundException {
        if (id3v22FieldKey == null) {
            throw new KeyNotFoundException();
        }
        AbstractID3v2Tag.FrameAndSubId frameAndSubId = new AbstractID3v2Tag.FrameAndSubId(id3v22FieldKey.getFrameId(), id3v22FieldKey.getSubId());
        if (id3v22FieldKey == ID3v22FieldKey.TRACK) {
            AbstractID3v2Frame frame = this.getFirstField(frameAndSubId.getFrameId());
            return String.valueOf(((FrameBodyTRCK)frame.getBody()).getTrackNo());
        }
        if (id3v22FieldKey == ID3v22FieldKey.TRACK_TOTAL) {
            AbstractID3v2Frame frame = this.getFirstField(frameAndSubId.getFrameId());
            return String.valueOf(((FrameBodyTRCK)frame.getBody()).getTrackTotal());
        }
        if (id3v22FieldKey == ID3v22FieldKey.DISC_NO) {
            AbstractID3v2Frame frame = this.getFirstField(frameAndSubId.getFrameId());
            return String.valueOf(((FrameBodyTPOS)frame.getBody()).getDiscNo());
        }
        if (id3v22FieldKey == ID3v22FieldKey.DISC_TOTAL) {
            AbstractID3v2Frame frame = this.getFirstField(frameAndSubId.getFrameId());
            return String.valueOf(((FrameBodyTPOS)frame.getBody()).getDiscTotal());
        }
        return super.doGetValueAtIndex(frameAndSubId, 0);
    }

    public void deleteField(ID3v22FieldKey id3v22FieldKey) throws KeyNotFoundException {
        if (id3v22FieldKey == null) {
            throw new KeyNotFoundException();
        }
        super.doDeleteTagField(new AbstractID3v2Tag.FrameAndSubId(id3v22FieldKey.getFrameId(), id3v22FieldKey.getSubId()));
    }

    @Override
    public void deleteField(String id) {
        super.doDeleteTagField(new AbstractID3v2Tag.FrameAndSubId(id, null));
    }

    @Override
    protected AbstractID3v2Tag.FrameAndSubId getFrameAndSubIdFromGenericKey(FieldKey genericKey) {
        ID3v22FieldKey id3v22FieldKey = ID3v22Frames.getInstanceOf().getId3KeyFromGenericKey(genericKey);
        if (id3v22FieldKey == null) {
            throw new KeyNotFoundException();
        }
        return new AbstractID3v2Tag.FrameAndSubId(id3v22FieldKey.getFrameId(), id3v22FieldKey.getSubId());
    }

    @Override
    protected ID3Frames getID3Frames() {
        return ID3v22Frames.getInstanceOf();
    }

    @Override
    public Comparator getPreferredFrameOrderComparator() {
        return ID3v22PreferredFrameOrderComparator.getInstanceof();
    }

    @Override
    public List<Artwork> getArtworkList() {
        List<TagField> coverartList = this.getFields(FieldKey.COVER_ART);
        ArrayList<Artwork> artworkList = new ArrayList<Artwork>(coverartList.size());
        for (TagField next : coverartList) {
            FrameBodyPIC coverArt = (FrameBodyPIC)((AbstractID3v2Frame)next).getBody();
            Artwork artwork = new Artwork();
            artwork.setMimeType(ImageFormats.getMimeTypeForFormat(coverArt.getFormatType()));
            artwork.setPictureType(coverArt.getPictureType());
            artwork.setBinaryData(coverArt.getImageData());
            artworkList.add(artwork);
        }
        return artworkList;
    }

    @Override
    public TagField createField(Artwork artwork) throws FieldDataInvalidException {
        ID3v22Frame frame = this.createFrame(this.getFrameAndSubIdFromGenericKey(FieldKey.COVER_ART).getFrameId());
        FrameBodyPIC body = (FrameBodyPIC)frame.getBody();
        body.setObjectValue("PictureData", artwork.getBinaryData());
        body.setObjectValue("PictureType", artwork.getPictureType());
        body.setObjectValue("ImageType", ImageFormats.getFormatForMimeType(artwork.getMimeType()));
        body.setObjectValue("Description", "");
        return frame;
    }

    public TagField createArtworkField(byte[] data, String mimeType) {
        ID3v22Frame frame = this.createFrame(this.getFrameAndSubIdFromGenericKey(FieldKey.COVER_ART).getFrameId());
        FrameBodyPIC body = (FrameBodyPIC)frame.getBody();
        body.setObjectValue("PictureData", data);
        body.setObjectValue("PictureType", PictureTypes.DEFAULT_ID);
        body.setObjectValue("ImageType", ImageFormats.getFormatForMimeType(mimeType));
        body.setObjectValue("Description", "");
        return frame;
    }
}

