/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.TaggedIOException;
import org.apache.commons.io.output.ProxyOutputStream;

public class TaggedOutputStream
extends ProxyOutputStream {
    public TaggedOutputStream(OutputStream proxy) {
        super(proxy);
    }

    public boolean isCauseOf(IOException exception) {
        if (exception instanceof TaggedIOException) {
            TaggedIOException tagged = (TaggedIOException)exception;
            return this == tagged.getTag();
        }
        return false;
    }

    public void throwIfCauseOf(Exception exception) throws IOException {
        TaggedIOException tagged;
        if (exception instanceof TaggedIOException && this == (tagged = (TaggedIOException)exception).getTag()) {
            throw tagged.getCause();
        }
    }

    protected void handleIOException(IOException e) throws IOException {
        throw new TaggedIOException(e, this);
    }
}

