/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.monitor.FilesystemObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilesystemMonitor
implements Runnable {
    private final long interval;
    private final List<FilesystemObserver> observers = new CopyOnWriteArrayList<FilesystemObserver>();
    private Thread thread = null;
    private volatile boolean running = false;

    public FilesystemMonitor() {
        this(10000L);
    }

    public FilesystemMonitor(long interval) {
        this.interval = interval;
    }

    public FilesystemMonitor(long interval, FilesystemObserver ... observers) {
        this(interval);
        if (observers != null) {
            for (FilesystemObserver observer : observers) {
                this.addObserver(observer);
            }
        }
    }

    public void addObserver(FilesystemObserver observer) {
        if (observer != null) {
            this.observers.add(observer);
        }
    }

    public void removeObserver(FilesystemObserver observer) {
        if (observer != null) {
            while (this.observers.remove(observer)) {
            }
        }
    }

    public Iterable<FilesystemObserver> getObservers() {
        return this.observers;
    }

    public void start() throws Exception {
        for (FilesystemObserver observer : this.observers) {
            observer.initialize();
        }
        this.running = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() throws Exception {
        this.running = false;
        try {
            this.thread.join(this.interval);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        for (FilesystemObserver observer : this.observers) {
            observer.destroy();
        }
    }

    @Override
    public void run() {
        while (this.running) {
            for (FilesystemObserver observer : this.observers) {
                observer.checkAndNotify();
            }
            if (!this.running) break;
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

