/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.io.File;
import java.io.Serializable;
import org.apache.commons.io.monitor.FilesystemObserver;

public class FilesystemEntry
implements Serializable {
    private final FilesystemEntry parent;
    private FilesystemEntry[] children;
    private File file;
    private String name;
    private boolean exists;
    private boolean directory;
    private long lastModified;

    public FilesystemEntry(File file) {
        this(null, file);
    }

    public FilesystemEntry(FilesystemEntry parent, File file) {
        if (file == null) {
            throw new IllegalArgumentException("File is missing");
        }
        this.file = file;
        this.parent = parent;
        this.name = file.getName();
    }

    public void refresh() {
        this.name = this.file.getName();
        this.exists = this.file.exists();
        if (this.exists) {
            this.directory = this.file.isDirectory();
            this.lastModified = this.file.lastModified();
        }
    }

    public FilesystemEntry newChildInstance(File file) {
        return new FilesystemEntry(this, file);
    }

    public boolean hasChanged() {
        return this.lastModified != this.file.lastModified();
    }

    public FilesystemEntry getParent() {
        return this.parent;
    }

    public int getLevel() {
        return this.parent == null ? 0 : this.parent.getLevel() + 1;
    }

    public FilesystemEntry[] getChildren() {
        return this.children != null ? this.children : FilesystemObserver.EMPTY_ENTRIES;
    }

    public void setChildren(FilesystemEntry[] children) {
        this.children = children;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public boolean isExists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }
}

