/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public abstract class ProxyReader
extends FilterReader {
    public ProxyReader(Reader proxy) {
        super(proxy);
    }

    public int read() throws IOException {
        try {
            return this.in.read();
        }
        catch (IOException e) {
            this.handleIOException(e);
            return -1;
        }
    }

    public int read(char[] chr) throws IOException {
        try {
            return this.in.read(chr);
        }
        catch (IOException e) {
            this.handleIOException(e);
            return -1;
        }
    }

    public int read(char[] chr, int st, int end) throws IOException {
        try {
            return this.in.read(chr, st, end);
        }
        catch (IOException e) {
            this.handleIOException(e);
            return -1;
        }
    }

    public int read(CharBuffer target) throws IOException {
        try {
            return this.in.read(target);
        }
        catch (IOException e) {
            this.handleIOException(e);
            return -1;
        }
    }

    public long skip(long ln) throws IOException {
        try {
            return this.in.skip(ln);
        }
        catch (IOException e) {
            this.handleIOException(e);
            return 0L;
        }
    }

    public boolean ready() throws IOException {
        try {
            return this.in.ready();
        }
        catch (IOException e) {
            this.handleIOException(e);
            return false;
        }
    }

    public void close() throws IOException {
        try {
            this.in.close();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    public synchronized void mark(int idx) throws IOException {
        try {
            this.in.mark(idx);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    public synchronized void reset() throws IOException {
        try {
            this.in.reset();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    protected void handleIOException(IOException e) throws IOException {
        throw e;
    }
}

