/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.utils;

import com.thoughtworks.xstream.XStream;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sourceforge.atunes.kernel.modules.playlist.PlayList;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeed;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.data.Folder;
import net.sourceforge.atunes.kernel.modules.repository.data.Genre;
import net.sourceforge.atunes.kernel.modules.repository.data.Repository;
import net.sourceforge.atunes.kernel.modules.repository.data.RepositoryStructure;
import net.sourceforge.atunes.kernel.modules.repository.favorites.Favorites;
import net.sourceforge.atunes.kernel.modules.repository.statistics.AudioFileStats;
import net.sourceforge.atunes.kernel.modules.repository.statistics.Statistics;
import net.sourceforge.atunes.kernel.modules.repository.statistics.StatisticsAlbum;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.DefaultTag;
import net.sourceforge.atunes.misc.PointedList;
import net.sourceforge.atunes.misc.RankList;
import net.sourceforge.atunes.utils.ClosingUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class XMLUtils {
    private static ThreadLocal<XPath> xPath;

    private XMLUtils() {
    }

    public static Node evaluateXPathExpressionAndReturnNode(String string, Node node) {
        try {
            return (Node)XMLUtils.getXPath().get().evaluate(string, node, XPathConstants.NODE);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public static String evaluateXPathExpressionAndReturnString(String string, Node node) {
        try {
            return (String)XMLUtils.getXPath().get().evaluate(string, node, XPathConstants.STRING);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public static NodeList evaluateXPathExpressionAndReturnNodeList(String string, Node node) {
        try {
            return (NodeList)XMLUtils.getXPath().get().evaluate(string, node, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public static String getAttributeValue(Element element, String string) {
        return null == element ? null : element.getAttribute(string);
    }

    public static Element getChildElement(Element element, String string) {
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public static String getChildElementContent(Element element, String string) {
        Element element2 = XMLUtils.getChildElement(element, string);
        return element2 == null ? "" : element2.getTextContent();
    }

    public static Document getXMLDocument(String string) {
        if (null != string && !string.isEmpty()) {
            try {
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                return documentBuilder.parse(new InputSource(new StringReader(string)));
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readBeanFromFile(String string) throws IOException {
        Object object;
        XMLDecoder xMLDecoder = null;
        try {
            xMLDecoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(string)));
            object = xMLDecoder.readObject();
        }
        catch (Throwable throwable) {
            ClosingUtils.close(xMLDecoder);
            throw throwable;
        }
        ClosingUtils.close(xMLDecoder);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObjectFromFile(String string) throws IOException {
        Object object;
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8");
            object = XMLUtils.getXStream().fromXML((Reader)inputStreamReader);
        }
        catch (Throwable throwable) {
            ClosingUtils.close(inputStreamReader);
            throw throwable;
        }
        ClosingUtils.close(inputStreamReader);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObjectFromFile(InputStream inputStream) throws IOException {
        Object object;
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream);
            object = XMLUtils.getXStream().fromXML((Reader)inputStreamReader);
        }
        catch (Throwable throwable) {
            ClosingUtils.close(inputStreamReader);
            throw throwable;
        }
        ClosingUtils.close(inputStreamReader);
        return object;
    }

    public static Object readObjectFromString(String string) {
        return XMLUtils.getXStream().fromXML(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBeanToFile(Object object, String string) throws IOException {
        XMLEncoder xMLEncoder = null;
        try {
            xMLEncoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(string)));
            xMLEncoder.writeObject(object);
        }
        catch (Throwable throwable) {
            ClosingUtils.close(xMLEncoder);
            throw throwable;
        }
        ClosingUtils.close(xMLEncoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObjectToFile(Object object, String string) throws IOException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8");
            XMLUtils.getXStream().toXML(object, (Writer)outputStreamWriter);
        }
        catch (Throwable throwable) {
            ClosingUtils.close(outputStreamWriter);
            throw throwable;
        }
        ClosingUtils.close(outputStreamWriter);
    }

    private static XStream getXStream() {
        XStream xStream = new XStream();
        xStream.alias("Repository", Repository.class);
        xStream.alias("RepositoryStats", Statistics.class);
        xStream.alias("RepositoryStructure", RepositoryStructure.class);
        xStream.alias("SongStats", AudioFileStats.class);
        xStream.alias("RankList", RankList.class);
        xStream.alias("StatisticsAlbum", StatisticsAlbum.class);
        xStream.alias("AudioFile", AudioFile.class);
        xStream.alias("Radio", Radio.class);
        xStream.alias("PodcastFeed", PodcastFeed.class);
        xStream.alias("PodcastFeedEntry", PodcastFeedEntry.class);
        xStream.alias("Artist", Artist.class);
        xStream.alias("Album", Album.class);
        xStream.alias("Folder", Folder.class);
        xStream.alias("Genre", Genre.class);
        xStream.alias("DefaultTag", DefaultTag.class);
        xStream.alias("PlayList", PlayList.class);
        xStream.alias("Favorites", Favorites.class);
        xStream.omitField(Radio.class, "title");
        xStream.omitField(Radio.class, "artist");
        xStream.omitField(Radio.class, "songInfoAvailable");
        xStream.omitField(PointedList.class, "list");
        return xStream;
    }

    private static ThreadLocal<XPath> getXPath() {
        if (xPath == null) {
            xPath = new ThreadLocal<XPath>(){

                @Override
                protected XPath initialValue() {
                    return XPathFactory.newInstance().newXPath();
                }
            };
        }
        return xPath;
    }
}

