/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.utils;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.atunes.utils.I18nUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.commonjukebox.plugins.model.PluginApi;

@PluginApi
public final class StringUtils {
    private static final long KILOBYTE = 1024L;
    private static final long MEGABYTE = 0x100000L;
    private static final long GIGABYTE = 0x40000000L;
    private static final long SECONDS_MINUTE = 60L;
    private static final long SECONDS_HOUR = 3600L;
    private static final long SECONDS_DAY = 86400L;

    private StringUtils() {
    }

    public static String fromByteToMegaOrGiga(long l) {
        if (l < 1024L) {
            return StringUtils.getString(String.valueOf(l), " Bytes");
        }
        if (l < 0x100000L) {
            return StringUtils.getString(StringUtils.toString((double)l / 1024.0, 2), " KB");
        }
        if (l < 0x40000000L) {
            return StringUtils.getString(StringUtils.toString((double)l / 1048576.0, 2), " MB");
        }
        return StringUtils.getString(StringUtils.toString((double)l / 1.073741824E9, 2), " GB");
    }

    public static String fromSecondsToHoursAndDays(long l) {
        long l2 = l;
        long l3 = l2 / 86400L;
        long l4 = (l2 %= 86400L) / 3600L;
        long l5 = (l2 %= 3600L) / 60L;
        String string = StringUtils.getString(l4, ":", l5 < 10L ? "0" : "", l5, ":", (l2 %= 60L) < 10L ? "0" : "", l2);
        if (l3 == 1L) {
            return StringUtils.getString(l3, " ", I18nUtils.getString("DAY"), " ", string);
        }
        if (l3 > 1L) {
            return StringUtils.getString(l3, " ", I18nUtils.getString("DAYS"), " ", string);
        }
        return string;
    }

    public static List<String> fromStringArrayToList(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        String string = "";
        for (String string2 : stringArray) {
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                arrayList.add(string2.replaceAll("\"", ""));
                continue;
            }
            if (string2.endsWith("\"")) {
                bl = false;
                string = StringUtils.getString(string, " ", string2.replaceAll("\"", ""));
                arrayList.add(string);
                continue;
            }
            if (string2.startsWith("\"")) {
                bl = true;
                string = string2.replaceFirst("\"", "");
                continue;
            }
            if (bl) {
                string = StringUtils.getString(string, " ", string2);
                continue;
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static String getString(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objectArray) {
            stringBuilder.append(object);
        }
        return stringBuilder.toString();
    }

    public static String toString(double d, int n) {
        DecimalFormat decimalFormat = new DecimalFormat("#.#");
        decimalFormat.setMinimumFractionDigits(n);
        return decimalFormat.format(d);
    }

    public static String convertFirstCharacterToUppercase(String string) {
        if (string != null && !string.isEmpty()) {
            String string2 = String.valueOf(Character.toUpperCase(string.charAt(0)));
            if (string.length() > 1) {
                string2 = string2 + string.substring(1);
            }
            return string2;
        }
        return string;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static String unescapeHTML(String string, int n) {
        return StringEscapeUtils.unescapeHtml((String)string.substring(n));
    }

    public static int getNumberOrZero(String string) {
        if (StringUtils.isEmpty(string)) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static List<String> getTextBetweenChars(String string, char c, char c2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.indexOf(c) == -1 || string.indexOf(c2) == -1) {
            return arrayList;
        }
        String string2 = string;
        int n = string2.indexOf(c);
        int n2 = string2.indexOf(c2);
        while (n != -1 && n2 != -1) {
            if (n < n2) {
                arrayList.add(string2.substring(n, n2 + 1));
            }
            string2 = string2.substring(n2 + 1);
            n = string2.indexOf(c);
            n2 = string2.indexOf(c2);
        }
        return arrayList;
    }

    public static String microseconds2String(long l) {
        long l2 = l / 1000000L;
        int n = (int)l2 / 60;
        return StringUtils.getString(n, ":", (l2 %= 60L) < 10L ? "0" : "", l2);
    }

    public static String milliseconds2String(long l) {
        long l2 = l / 1000L;
        int n = (int)l2 / 60;
        return StringUtils.getString(n, ":", (l2 %= 60L) < 10L ? "0" : "", l2);
    }

    public static String seconds2String(long l) {
        long l2 = l;
        int n = (int)l2 / 60;
        return StringUtils.getString(n, ":", (l2 %= 60L) < 10L ? "0" : "", l2);
    }
}

