/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.utils;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.WString;
import net.sourceforge.atunes.kernel.modules.pattern.AbstractPattern;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.StringUtils;

public final class FileNameUtils {
    private static final int CHAR_BYTE_WIDTH = 2;
    private static Kernel32 kernel32;

    private FileNameUtils() {
    }

    public static String getValidFileName(String string) {
        return FileNameUtils.getValidFileName(string, false);
    }

    public static String getValidFileName(String string, boolean bl) {
        String string2 = FileNameUtils.getValidName(string, bl);
        string2 = string2.replaceAll("/", "-");
        string2 = string2.replaceAll("\"", "'");
        string2 = string2.replaceAll("\\?", "");
        string2 = string2.replaceAll("\\*", "");
        string2 = string2.replaceAll(":", "");
        if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS || bl) {
            string2 = string2.replace("\\", "-");
        }
        return string2;
    }

    public static String getValidFolderName(String string) {
        return FileNameUtils.getValidFolderName(string, false);
    }

    public static String getValidFolderName(String string, boolean bl) {
        String string2 = FileNameUtils.getValidName(string, bl);
        if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS || bl) {
            string2 = string2.replace("\\.", "\\_");
            if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS) {
                string2 = string2 + "\\";
            }
            string2 = string2.replace(".\\", "_\\");
            if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS) {
                string2 = string2.replace("/", "-");
            }
        }
        return string2;
    }

    private static String getValidName(String string, boolean bl) {
        String string2 = string;
        if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS || bl) {
            string2 = string2.replace("\"", "'");
            if ((string2 = string2.replace("?", "_")).length() > 2) {
                string2 = string2.substring(0, 2) + string2.substring(2).replace(":", "-");
            }
            string2 = string2.replace("<", "-");
            string2 = string2.replace(">", "-");
            string2 = string2.replace("|", "-");
            string2 = string2.replace("*", "-");
        }
        if (SystemProperties.OS == SystemProperties.OperatingSystem.MACOSX) {
            string2 = string2.replace("|", "-");
        }
        return string2;
    }

    public static String getNewFileName(String string, AudioFile audioFile) {
        String string2 = AbstractPattern.applyPatternTransformations(string, audioFile);
        string2 = string2.replace("\\", "\\\\").replace("$", "\\$");
        string2 = StringUtils.getString(string2, audioFile.getFile().getName().substring(audioFile.getFile().getName().lastIndexOf(46)));
        string2 = FileNameUtils.getValidFileName(string2);
        return string2;
    }

    public static String getNewFolderPath(String string, AudioFile audioFile) {
        String string2 = AbstractPattern.applyPatternTransformations(string, audioFile);
        string2 = string2.replace("\\", "\\\\").replace("$", "\\$");
        string2 = FileNameUtils.getValidName(string2, false);
        return string2;
    }

    public static String getShortPathNameW(String string) {
        if (SystemProperties.OS != SystemProperties.OperatingSystem.WINDOWS) {
            return string;
        }
        WString wString = new WString(string);
        int n = wString.length() * 2 + 2;
        Memory memory = new Memory((long)n);
        if (kernel32.GetShortPathNameW(wString, memory, n) == 0) {
            return "";
        }
        return memory.getString(0L, true);
    }

    static {
        try {
            Native.setProtected((boolean)true);
            kernel32 = (Kernel32)Native.loadLibrary((String)"Kernel32", Kernel32.class);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            new Logger().debug("NATIVE      ", "kernel32 not found");
        }
    }

    public static interface Kernel32
    extends Library {
        public int GetShortPathNameW(WString var1, Memory var2, int var3);
    }
}

