/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.utils;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import net.sourceforge.atunes.utils.StringUtils;

public final class DateUtils {
    private static Locale locale = Locale.getDefault();

    private DateUtils() {
    }

    public static Calendar getCalendar() {
        return Calendar.getInstance(locale);
    }

    public static int getCurrentYear() {
        return DateUtils.getCalendar().get(1);
    }

    public static Date parseRFC3339Date(String string) {
        try {
            Date date = new Date();
            if (string.endsWith("Z")) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    date = simpleDateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'");
                    simpleDateFormat.setLenient(true);
                    try {
                        date = simpleDateFormat.parse(string);
                    }
                    catch (ParseException parseException2) {
                        return null;
                    }
                }
                return date;
            }
            String string2 = string.substring(0, string.lastIndexOf(45));
            String string3 = string.substring(string.lastIndexOf(45));
            string3 = StringUtils.getString(string3.substring(0, string3.indexOf(58)), string3.substring(string3.indexOf(58) + 1));
            String string4 = StringUtils.getString(string2, string3);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            try {
                date = simpleDateFormat.parse(string4);
            }
            catch (ParseException parseException) {
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ");
                simpleDateFormat.setLenient(true);
                try {
                    date = simpleDateFormat.parse(string4);
                }
                catch (ParseException parseException3) {
                    return null;
                }
            }
            return date;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Date parseRFC822Date(String string) {
        try {
            return new MailDateFormat().parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static void setLocale(Locale locale) {
        DateUtils.locale = locale;
    }

    public static String toPathString(Date date) {
        return DateFormat.getDateTimeInstance(3, 3, locale).format(date).replaceAll("/", "-");
    }

    public static String toString(Date date) {
        return DateFormat.getDateTimeInstance(3, 3, locale).format(date);
    }

    static class MailDateFormat
    extends SimpleDateFormat {
        private static final long serialVersionUID = -8148227605210628779L;
        private static boolean debug = false;
        private static TimeZone tz = TimeZone.getTimeZone("GMT");
        private static Calendar cal = new GregorianCalendar(tz);

        public MailDateFormat() {
            super("EEE, d MMM yyyy HH:mm:ss 'XXXXX' (z)", Locale.US);
        }

        private static synchronized Date ourUTC(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
            cal.clear();
            cal.setLenient(bl);
            cal.set(1, n);
            cal.set(2, n2);
            cal.set(5, n3);
            cal.set(11, n4);
            cal.set(12, n5 + n7);
            cal.set(13, n6);
            return cal.getTime();
        }

        private static Date parseDate(char[] cArray, ParsePosition parsePosition, boolean bl) {
            try {
                MailDateParser mailDateParser;
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                block11: {
                    n7 = -1;
                    n6 = -1;
                    n5 = -1;
                    n4 = 0;
                    n3 = 0;
                    n2 = 0;
                    n = 0;
                    mailDateParser = new MailDateParser(cArray);
                    mailDateParser.skipUntilNumber();
                    n7 = mailDateParser.parseNumber();
                    if (!mailDateParser.skipIfChar('-')) {
                        mailDateParser.skipWhiteSpace();
                    }
                    n6 = mailDateParser.parseMonth();
                    if (!mailDateParser.skipIfChar('-')) {
                        mailDateParser.skipWhiteSpace();
                    }
                    if ((n5 = mailDateParser.parseNumber()) < 50) {
                        n5 += 2000;
                    } else if (n5 < 100) {
                        n5 += 1900;
                    }
                    mailDateParser.skipWhiteSpace();
                    n4 = mailDateParser.parseNumber();
                    mailDateParser.skipChar(':');
                    n3 = mailDateParser.parseNumber();
                    if (mailDateParser.skipIfChar(':')) {
                        n2 = mailDateParser.parseNumber();
                    }
                    try {
                        mailDateParser.skipWhiteSpace();
                        n = mailDateParser.parseTimeZone();
                    }
                    catch (ParseException parseException) {
                        if (!debug) break block11;
                        System.out.println(StringUtils.getString("No timezone? : '", new String(cArray), "'"));
                    }
                }
                parsePosition.setIndex(mailDateParser.getIndex());
                return MailDateFormat.ourUTC(n5, n6, n7, n4, n3, n2, n, bl);
            }
            catch (Exception exception) {
                if (debug) {
                    System.out.println(StringUtils.getString("Bad date: '", new String(cArray), "'"));
                    exception.printStackTrace();
                }
                parsePosition.setIndex(1);
                return null;
            }
        }

        @Override
        public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            int n = stringBuffer.length();
            super.format(date, stringBuffer, fieldPosition);
            int n2 = 0;
            n2 = n + 25;
            while (stringBuffer.charAt(n2) != 'X') {
                ++n2;
            }
            this.calendar.clear();
            this.calendar.setTime(date);
            int n3 = this.calendar.get(15) + this.calendar.get(16);
            if (n3 < 0) {
                stringBuffer.setCharAt(n2++, '-');
                n3 = -n3;
            } else {
                stringBuffer.setCharAt(n2++, '+');
            }
            int n4 = n3 / 60 / 1000;
            int n5 = n4 / 60;
            int n6 = n4 % 60;
            stringBuffer.setCharAt(n2++, Character.forDigit(n5 / 10, 10));
            stringBuffer.setCharAt(n2++, Character.forDigit(n5 % 10, 10));
            stringBuffer.setCharAt(n2++, Character.forDigit(n6 / 10, 10));
            stringBuffer.setCharAt(n2++, Character.forDigit(n6 % 10, 10));
            return stringBuffer;
        }

        @Override
        public Date parse(String string, ParsePosition parsePosition) {
            return MailDateFormat.parseDate(string.toCharArray(), parsePosition, this.isLenient());
        }

        @Override
        public void setCalendar(Calendar calendar) {
            throw new RuntimeException("Method setCalendar() shouldn't be called");
        }

        @Override
        public void setNumberFormat(NumberFormat numberFormat) {
            throw new RuntimeException("Method setNumberFormat() shouldn't be called");
        }

        static class MailDateParser {
            private int index = 0;
            private char[] orig = null;

            public MailDateParser(char[] cArray) {
                this.orig = cArray;
            }

            int getIndex() {
                return this.index;
            }

            public int parseAlphaTimeZone() throws ParseException {
                char c;
                int n = 0;
                boolean bl = false;
                try {
                    switch (this.orig[this.index++]) {
                        case 'U': 
                        case 'u': {
                            c = this.orig[this.index++];
                            if (c == 'T' || c == 't') {
                                n = 0;
                                break;
                            }
                            throw new ParseException("Bad Alpha TimeZone", this.index);
                        }
                        case 'G': 
                        case 'g': {
                            c = this.orig[this.index++];
                            if (!(c != 'M' && c != 'm' || (c = this.orig[this.index++]) != 'T' && c != 't')) {
                                n = 0;
                                break;
                            }
                            throw new ParseException("Bad Alpha TimeZone", this.index);
                        }
                        case 'E': 
                        case 'e': {
                            n = 300;
                            bl = true;
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            n = 360;
                            bl = true;
                            break;
                        }
                        case 'M': 
                        case 'm': {
                            n = 420;
                            bl = true;
                            break;
                        }
                        case 'P': 
                        case 'p': {
                            n = 480;
                            bl = true;
                            break;
                        }
                        default: {
                            throw new ParseException("Bad Alpha TimeZone", this.index);
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new ParseException("Bad Alpha TimeZone", this.index);
                }
                if (bl) {
                    if ((c = this.orig[this.index++]) == 'S' || c == 's') {
                        if ((c = this.orig[this.index++]) != 'T' && c != 't') {
                            throw new ParseException("Bad Alpha TimeZone", this.index);
                        }
                    } else if (c == 'D' || c == 'd') {
                        if ((c = this.orig[this.index++]) == 'T' || c != 't') {
                            n -= 60;
                        } else {
                            throw new ParseException("Bad Alpha TimeZone", this.index);
                        }
                    }
                }
                return n;
            }

            public int parseMonth() throws ParseException {
                try {
                    switch (this.orig[this.index++]) {
                        case 'J': 
                        case 'j': {
                            switch (this.orig[this.index++]) {
                                case 'A': 
                                case 'a': {
                                    char c = this.orig[this.index++];
                                    if (c != 'N' && c != 'n') break;
                                    return 0;
                                }
                                case 'U': 
                                case 'u': {
                                    char c = this.orig[this.index++];
                                    if (c == 'N' || c == 'n') {
                                        return 5;
                                    }
                                    if (c != 'L' && c != 'l') break;
                                    return 6;
                                }
                            }
                            break;
                        }
                        case 'F': 
                        case 'f': {
                            char c = this.orig[this.index++];
                            if (c != 'E' && c != 'e' || (c = this.orig[this.index++]) != 'B' && c != 'b') break;
                            return 1;
                        }
                        case 'M': 
                        case 'm': {
                            char c = this.orig[this.index++];
                            if (c != 'A' && c != 'a') break;
                            if ((c = this.orig[this.index++]) == 'R' || c == 'r') {
                                return 2;
                            }
                            if (c != 'Y' && c != 'y') break;
                            return 4;
                        }
                        case 'A': 
                        case 'a': {
                            char c = this.orig[this.index++];
                            if (c == 'P' || c == 'p') {
                                if ((c = this.orig[this.index++]) != 'R' && c != 'r') break;
                                return 3;
                            }
                            if (c != 'U' && c != 'u' || (c = this.orig[this.index++]) != 'G' && c != 'g') break;
                            return 7;
                        }
                        case 'S': 
                        case 's': {
                            char c = this.orig[this.index++];
                            if (c != 'E' && c != 'e' || (c = this.orig[this.index++]) != 'P' && c != 'p') break;
                            return 8;
                        }
                        case 'O': 
                        case 'o': {
                            char c = this.orig[this.index++];
                            if (c != 'C' && c != 'c' || (c = this.orig[this.index++]) != 'T' && c != 't') break;
                            return 9;
                        }
                        case 'N': 
                        case 'n': {
                            char c = this.orig[this.index++];
                            if (c != 'O' && c != 'o' || (c = this.orig[this.index++]) != 'V' && c != 'v') break;
                            return 10;
                        }
                        case 'D': 
                        case 'd': {
                            char c = this.orig[this.index++];
                            if (c != 'E' && c != 'e' || (c = this.orig[this.index++]) != 'C' && c != 'c') break;
                            return 11;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                throw new ParseException("Bad Month", this.index);
            }

            public int parseNumber() throws ParseException {
                int n = this.orig.length;
                boolean bl = false;
                int n2 = 0;
                while (this.index < n) {
                    switch (this.orig[this.index]) {
                        case '0': {
                            n2 *= 10;
                            bl = true;
                            break;
                        }
                        case '1': {
                            n2 = n2 * 10 + 1;
                            bl = true;
                            break;
                        }
                        case '2': {
                            n2 = n2 * 10 + 2;
                            bl = true;
                            break;
                        }
                        case '3': {
                            n2 = n2 * 10 + 3;
                            bl = true;
                            break;
                        }
                        case '4': {
                            n2 = n2 * 10 + 4;
                            bl = true;
                            break;
                        }
                        case '5': {
                            n2 = n2 * 10 + 5;
                            bl = true;
                            break;
                        }
                        case '6': {
                            n2 = n2 * 10 + 6;
                            bl = true;
                            break;
                        }
                        case '7': {
                            n2 = n2 * 10 + 7;
                            bl = true;
                            break;
                        }
                        case '8': {
                            n2 = n2 * 10 + 8;
                            bl = true;
                            break;
                        }
                        case '9': {
                            n2 = n2 * 10 + 9;
                            bl = true;
                            break;
                        }
                        default: {
                            if (bl) {
                                return n2;
                            }
                            throw new ParseException("No Number found", this.index);
                        }
                    }
                    ++this.index;
                }
                if (bl) {
                    return n2;
                }
                throw new ParseException("No Number found", this.index);
            }

            public int parseNumericTimeZone() throws ParseException {
                char c;
                boolean bl = false;
                if ((c = this.orig[this.index++]) == '+') {
                    bl = true;
                } else if (c != '-') {
                    throw new ParseException("Bad Numeric TimeZone", this.index);
                }
                int n = this.parseNumber();
                int n2 = n / 100 * 60 + n % 100;
                if (bl) {
                    return -n2;
                }
                return n2;
            }

            public int parseTimeZone() throws ParseException {
                if (this.index >= this.orig.length) {
                    throw new ParseException("No more characters", this.index);
                }
                char c = this.orig[this.index];
                if (c == '+' || c == '-') {
                    return this.parseNumericTimeZone();
                }
                return this.parseAlphaTimeZone();
            }

            public int peekChar() throws ParseException {
                if (this.index < this.orig.length) {
                    return this.orig[this.index];
                }
                throw new ParseException("No more characters", this.index);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void skipChar(char c) throws ParseException {
                if (this.index >= this.orig.length) throw new ParseException("No more characters", this.index);
                if (this.orig[this.index] != c) throw new ParseException("Wrong char", this.index);
                ++this.index;
            }

            public boolean skipIfChar(char c) throws ParseException {
                if (this.index < this.orig.length) {
                    if (this.orig[this.index] == c) {
                        ++this.index;
                        return true;
                    }
                    return false;
                }
                throw new ParseException("No more characters", this.index);
            }

            public void skipUntilNumber() throws ParseException {
                try {
                    while (true) {
                        switch (this.orig[this.index]) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                return;
                            }
                        }
                        ++this.index;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new ParseException("No Number Found", this.index);
                }
            }

            public void skipWhiteSpace() {
                int n = this.orig.length;
                block3: while (this.index < n) {
                    switch (this.orig[this.index]) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            ++this.index;
                            continue block3;
                        }
                    }
                    return;
                }
            }
        }
    }
}

