/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.utils;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.ImageUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.datatype.Artwork;

public final class AudioFilePictureUtils {
    private AudioFilePictureUtils() {
    }

    public static void exportPicture(AudioFile audioFile, Component component) {
        try {
            JFileChooser jFileChooser = new JFileChooser();
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toUpperCase().endsWith("PNG");
                }

                @Override
                public String getDescription() {
                    return "PNG files";
                }
            };
            jFileChooser.setFileFilter(fileFilter);
            if (jFileChooser.showSaveDialog(component) == 0) {
                File file = jFileChooser.getSelectedFile();
                if (!file.getName().toUpperCase().endsWith("PNG")) {
                    file = new File(StringUtils.getString(file.getAbsolutePath(), ".png"));
                }
                if (!file.exists() || file.exists() && JOptionPane.showConfirmDialog(null, I18nUtils.getString("OVERWRITE_FILE")) == 0) {
                    AudioFilePictureUtils.savePictureToFile(audioFile, file);
                }
            }
        }
        catch (Exception exception) {
            new Logger().error("IMAGE       ", exception);
        }
    }

    public static ImageIcon getExternalPicture(AudioFile audioFile, int n, int n2) {
        return AudioFilePictureUtils.getExternalPicture(audioFile, 0, n, n2);
    }

    private static ImageIcon getExternalPicture(AudioFile audioFile, int n, int n2, int n3) {
        String string = AudioFilePictureUtils.getFileNameForCover(audioFile);
        ImageIcon imageIcon = null;
        if (new File(string).exists()) {
            imageIcon = new ImageIcon(string);
        } else if (audioFile != null && audioFile.getExternalPictures() != null && audioFile.getExternalPictures().size() > n) {
            File file = audioFile.getExternalPictures().get(n);
            imageIcon = new ImageIcon(file.getAbsolutePath());
        }
        if (imageIcon != null) {
            if (n2 == -1 || n3 == -1) {
                return imageIcon;
            }
            int n4 = imageIcon.getIconWidth() > imageIcon.getIconHeight() ? imageIcon.getIconWidth() : imageIcon.getIconHeight();
            int n5 = (int)((float)imageIcon.getIconWidth() / (float)n4 * (float)n2);
            int n6 = (int)((float)imageIcon.getIconHeight() / (float)n4 * (float)n3);
            return ImageUtils.scaleImageBicubic(imageIcon.getImage(), n5, n6);
        }
        return imageIcon;
    }

    public static String getFileNameForCover(AudioFile audioFile) {
        if (audioFile == null) {
            return null;
        }
        return StringUtils.getString(audioFile.getFile().getParentFile().getAbsolutePath(), SystemProperties.FILE_SEPARATOR, audioFile.getArtist(), Character.valueOf('_'), audioFile.getAlbum(), "_Cover.", "png");
    }

    public static ImageIcon getInsidePicture(AudioFile audioFile, int n, int n2) {
        try {
            BufferedImage bufferedImage;
            byte[] byArray;
            Tag tag = AudioFileIO.read((File)audioFile.getFile()).getTag();
            if (tag == null) {
                return null;
            }
            Artwork artwork = tag.getFirstArtwork();
            byte[] byArray2 = byArray = artwork != null ? artwork.getBinaryData() : null;
            if (byArray != null && (bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray))) != null) {
                ImageIcon imageIcon = new ImageIcon(bufferedImage);
                if (n != -1 || n2 != -1) {
                    int n3 = imageIcon.getIconWidth() > imageIcon.getIconHeight() ? imageIcon.getIconWidth() : imageIcon.getIconHeight();
                    int n4 = (int)((float)imageIcon.getIconWidth() / (float)n3 * (float)n);
                    int n5 = (int)((float)imageIcon.getIconHeight() / (float)n3 * (float)n2);
                    BufferedImage bufferedImage2 = ImageUtils.toBufferedImage(ImageUtils.scaleImageBicubic(imageIcon.getImage(), n4, n5).getImage());
                    if (bufferedImage2 != null) {
                        return new ImageIcon(bufferedImage2);
                    }
                } else {
                    return new ImageIcon(bufferedImage);
                }
            }
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            new Logger().error("IMAGE       ", StringUtils.getString("File not found: ", audioFile.getFile().getAbsolutePath()));
            return null;
        }
        catch (Exception exception) {
            new Logger().error("IMAGE       ", exception);
            return null;
        }
    }

    public static ImageIcon[] getPicturesForFile(AudioFile audioFile, int n, int n2) {
        int n3 = 0;
        ImageIcon imageIcon = AudioFilePictureUtils.getInsidePicture(audioFile, n, n2);
        if (imageIcon != null) {
            ++n3;
        }
        ImageIcon[] imageIconArray = new ImageIcon[n3 += audioFile.getExternalPicturesCount()];
        int n4 = 0;
        if (imageIcon != null) {
            imageIconArray[0] = imageIcon;
            ++n4;
        }
        for (int i = n4; i < n3; ++i) {
            imageIconArray[i] = AudioFilePictureUtils.getExternalPicture(audioFile, i, n, n2);
        }
        return imageIconArray;
    }

    public static boolean isValidPicture(File file) {
        return file.getName().toUpperCase().endsWith("JPG") || file.getName().toUpperCase().endsWith("JPEG") || file.getName().toUpperCase().endsWith("PNG");
    }

    private static void savePictureToFile(AudioFile audioFile, File file) throws FileNotFoundException, IOException {
        ImageIcon imageIcon = AudioFilePictureUtils.getInsidePicture(audioFile, -1, -1);
        ImageUtils.writeImageToFile(imageIcon.getImage(), file.getAbsolutePath());
    }
}

