/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.misc.log;

import java.util.Enumeration;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.utils.StringUtils;
import org.apache.log4j.PropertyConfigurator;

public final class Log4jPropertiesLoader {
    private Log4jPropertiesLoader() {
    }

    public static void loadProperties(boolean bl) {
        try {
            PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(Log4jPropertiesLoader.class.getResourceAsStream("/settings/log4j.properties"));
            Enumeration<String> enumeration = propertyResourceBundle.getKeys();
            Properties properties = new Properties();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                String string2 = propertyResourceBundle.getString(string);
                if (string.equals("log4j.rootLogger") && bl) {
                    string2 = string2.replace("INFO", "DEBUG");
                } else if (string.equals("log4j.appender.A2.file")) {
                    string2 = StringUtils.getString(SystemProperties.getUserConfigFolder(bl), SystemProperties.FILE_SEPARATOR, "aTunes.log");
                }
                properties.setProperty(string, string2);
            }
            PropertyConfigurator.configure((Properties)properties);
        }
        catch (Exception exception) {
            System.out.println("ERROR trying to read logger configuration");
        }
    }
}

