/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.misc;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.sourceforge.atunes.kernel.ApplicationFinishListener;
import net.sourceforge.atunes.kernel.Kernel;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.utils.StringUtils;
import org.apache.commons.io.FileUtils;

public class TempFolder
implements ApplicationFinishListener {
    private static final TempFolder instance = new TempFolder();

    TempFolder() {
        Kernel.getInstance().addFinishListener(this);
    }

    public static TempFolder getInstance() {
        return instance;
    }

    public File copyToTempFolder(File file) {
        File file2 = new File(StringUtils.getString(SystemProperties.getTempFolder(), SystemProperties.FILE_SEPARATOR, file.getName()));
        try {
            FileUtils.copyFile((File)file, (File)file2);
        }
        catch (IOException iOException) {
            return null;
        }
        return file2;
    }

    public File writeImageToTempFolder(RenderedImage renderedImage, String string) {
        try {
            File file = new File(SystemProperties.getTempFolder(), string);
            ImageIO.write(renderedImage, "png", file);
            return file;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean removeFile(File file) {
        return file.delete();
    }

    public void removeAllFiles() {
        File[] fileArray;
        File file = new File(SystemProperties.getTempFolder());
        for (File file2 : fileArray = file.listFiles()) {
            file2.delete();
        }
    }

    @Override
    public void applicationFinish() {
        this.removeAllFiles();
    }
}

