/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.webservices.youtube;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.List;
import javax.swing.SwingWorker;
import net.sourceforge.atunes.gui.views.dialogs.TransferProgressDialog;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.proxy.Proxy;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.webservices.youtube.YoutubeResultEntry;
import net.sourceforge.atunes.kernel.modules.webservices.youtube.YoutubeService;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.ClosingUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.NetworkUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class YoutubeVideoDownloader
extends SwingWorker<Void, String> {
    private Logger logger;
    private static final String TOTAL = "total=";
    private static final String CURRENT = "current=";
    private long totalBytes;
    private YoutubeResultEntry entry;
    private File file;
    private TransferProgressDialog progressDialog;
    private boolean cancelled = false;

    public YoutubeVideoDownloader(YoutubeResultEntry youtubeResultEntry, File file) {
        this.entry = youtubeResultEntry;
        File file2 = file;
        if (!file.getAbsolutePath().toUpperCase().endsWith(".mp4")) {
            file2 = new File(StringUtils.getString(file.getAbsolutePath(), ".mp4"));
        }
        this.file = file2;
        this.progressDialog = GuiHandler.getInstance().getNewTransferProgressDialog(youtubeResultEntry.getName(), null);
        this.progressDialog.setIcon(youtubeResultEntry.getImage());
        this.progressDialog.setInfoText(I18nUtils.getString("DOWNLOADING"));
        this.progressDialog.addCancelButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                YoutubeVideoDownloader.this.cancelled = true;
            }
        });
        this.progressDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void doInBackground() throws Exception {
        block8: {
            String string = YoutubeService.getInstance().getDirectUrlToBeAbleToPlaySong(this.entry.getUrl());
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                int n;
                URLConnection uRLConnection = NetworkUtils.getConnection(string, Proxy.getProxy(ApplicationState.getInstance().getProxy()));
                this.publish(StringUtils.getString(TOTAL, Integer.toString(uRLConnection.getContentLength())));
                inputStream = uRLConnection.getInputStream();
                fileOutputStream = new FileOutputStream(this.file);
                byte[] byArray = new byte[1024];
                long l = System.currentTimeMillis();
                long l2 = 0L;
                while ((n = inputStream.read(byArray)) > 0 && !this.cancelled) {
                    fileOutputStream.write(byArray, 0, n);
                    l2 += (long)n;
                    if (System.currentTimeMillis() - l <= 1000L) continue;
                    this.publish(StringUtils.getString(CURRENT, Long.toString(l2)));
                    l = System.currentTimeMillis();
                }
                ClosingUtils.close(inputStream);
            }
            catch (Exception exception) {
                this.getLogger().error("SERVICE     ", exception);
                break block8;
            }
            finally {
                ClosingUtils.close(inputStream);
                ClosingUtils.close(fileOutputStream);
                if (this.cancelled && this.file.exists()) {
                    this.file.delete();
                }
            }
            ClosingUtils.close(fileOutputStream);
            if (this.cancelled && this.file.exists()) {
                this.file.delete();
            }
        }
        return null;
    }

    @Override
    protected void process(List<String> list) {
        super.process(list);
        if (list.get(0).startsWith(TOTAL)) {
            this.totalBytes = Long.parseLong(list.get(0).substring(TOTAL.length()));
            this.progressDialog.setTotalProgress(this.totalBytes);
        } else if (list.get(0).startsWith(CURRENT)) {
            long l = Long.parseLong(list.get(0).substring(CURRENT.length()));
            this.progressDialog.setCurrentProgress(l);
            int n = (int)((double)l * 100.0 / (double)this.totalBytes);
            this.progressDialog.setProgressBarValue(n);
        }
    }

    @Override
    protected void done() {
        super.done();
        this.progressDialog.setVisible(false);
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

