/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.webservices.lyrics.engines;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.atunes.kernel.modules.proxy.Proxy;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.Lyrics;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.engines.AbstractLyricsEngine;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.StringUtils;

public class LyrcEngine
extends AbstractLyricsEngine {
    private Logger logger;
    private static final String ARTIST_WILDCARD = "(%ARTIST%)";
    private static final String SONG_WILDCARD = "(%SONG%)";
    private static final String BASE_URL = StringUtils.getString("http://www.lyrc.com.ar/en/tema1en.php?artist=", "(%ARTIST%)", "&songname=", "(%SONG%)");
    private static final String SUGGESTIONS_URL = "http://www.lyrc.com.ar/en/";
    private static final String ADD_LYRICS_URL = StringUtils.getString("http://www.lyrc.com.ar/en/add/add.php?tema=", "(%SONG%)", "&grupo=", "(%ARTIST%)");

    public LyrcEngine(Proxy proxy) {
        super(proxy);
    }

    private static boolean validToken(String string) {
        return string.matches("[A-Za-z]+");
    }

    private String getLyrics(String string, String string2, String string3) {
        try {
            String string4 = LyrcEngine.readURL(this.getConnection(string), "ISO-8859-1");
            if (string4.contains("Suggestions : <br>")) {
                Object object;
                Object object2;
                Object object3;
                this.getLogger().debugMethodCall("SERVICE     ", "Suggestions found");
                string4 = string4.substring(string4.indexOf("Suggestions : <br>"));
                string4 = string4.substring(0, string4.indexOf("<br><br"));
                HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
                while (string4.indexOf("href=\"") != -1) {
                    object3 = string4.substring(string4.indexOf("href=\"") + 6);
                    object3 = ((String)object3).substring(0, ((String)object3).indexOf("\">"));
                    object2 = string4.substring(string4.indexOf("'white'>") + 8);
                    object2 = ((String)object2).substring(0, ((String)object2).indexOf("</font>"));
                    hashMap.put(object2, object3);
                    string4 = string4.substring(string4.indexOf("</font>") + 11);
                }
                object3 = new ArrayList();
                object2 = new StringTokenizer(string2, " ");
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken();
                    if (!LyrcEngine.validToken((String)object)) continue;
                    object3.add(object);
                }
                object2 = new StringTokenizer(string3, " ");
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken();
                    if (!LyrcEngine.validToken((String)object)) continue;
                    object3.add(object);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    boolean bl = true;
                    Object object4 = object3.iterator();
                    while (object4.hasNext()) {
                        String string5 = (String)object4.next();
                        if (((String)entry.getKey()).toLowerCase().contains(string5.toLowerCase())) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    this.getLogger().debugMethodCall("SERVICE     ", "Found suggestion", (String)entry.getKey());
                    object4 = SUGGESTIONS_URL.concat((String)entry.getValue());
                    return this.getLyrics((String)object4, string2, string3);
                }
                this.getLogger().debugMethodCall("SERVICE     ", "No suitable suggestion found");
                return null;
            }
            string4 = string4.substring(string4.indexOf("</table>") + 8);
            int n = string4.indexOf("<p>");
            int n2 = string4.indexOf("<br>");
            if (n == -1) {
                n = Integer.MAX_VALUE;
            }
            if (n2 == -1) {
                n2 = Integer.MAX_VALUE;
            }
            string4 = string4.substring(0, n < n2 ? n : n2);
            if ((string4 = string4.replaceAll("<br />", "")).contains("<head>")) {
                return null;
            }
            return string4;
        }
        catch (Exception exception) {
            this.getLogger().error("SERVICE     ", StringUtils.getString(exception.getClass().getCanonicalName(), " (", exception.getMessage(), ")"));
            return null;
        }
    }

    @Override
    public Lyrics getLyricsFor(String string, String string2) {
        String string3 = BASE_URL.replace(ARTIST_WILDCARD, LyrcEngine.encodeString(string)).replace(SONG_WILDCARD, LyrcEngine.encodeString(string2));
        String string4 = this.getLyrics(string3, string, string2);
        return string4 != null ? new Lyrics(string4, string3) : null;
    }

    @Override
    public String getLyricsProviderName() {
        return "LyrcEngine";
    }

    @Override
    public String getUrlForAddingNewLyrics(String string, String string2) {
        return ADD_LYRICS_URL.replace(SONG_WILDCARD, LyrcEngine.encodeString(string2)).replace(ARTIST_WILDCARD, LyrcEngine.encodeString(string));
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

