/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.webservices.lastfm.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.roarsoftware.lastfm.Artist;
import net.roarsoftware.lastfm.ImageSize;
import net.sourceforge.atunes.kernel.modules.context.ArtistInfo;
import net.sourceforge.atunes.kernel.modules.context.SimilarArtistsInfo;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.data.LastFmArtist;

public class LastFmSimilarArtists
implements SimilarArtistsInfo {
    private static final long serialVersionUID = -8771547790339792068L;
    public static final int MAX_SIMILAR_ARTISTS = 15;
    private String artistName;
    private String picture;
    private List<ArtistInfo> artists;

    public static SimilarArtistsInfo getSimilarArtists(Collection<Artist> collection, Artist artist) {
        ArrayList<Artist> arrayList = new ArrayList<Artist>(collection);
        LastFmSimilarArtists lastFmSimilarArtists = new LastFmSimilarArtists();
        lastFmSimilarArtists.artistName = artist.getName();
        lastFmSimilarArtists.picture = artist.getImageURL(ImageSize.LARGE);
        lastFmSimilarArtists.artists = new ArrayList<ArtistInfo>();
        for (int i = 0; i < arrayList.size() && i != 15; ++i) {
            lastFmSimilarArtists.artists.add(LastFmArtist.getArtist((Artist)arrayList.get(i)));
        }
        return lastFmSimilarArtists;
    }

    @Override
    public String getArtistName() {
        return this.artistName;
    }

    @Override
    public List<ArtistInfo> getArtists() {
        return this.artists;
    }

    @Override
    public String getPicture() {
        return this.picture;
    }

    @Override
    public void setArtistName(String string) {
        this.artistName = string;
    }

    @Override
    public void setArtists(List<? extends ArtistInfo> list) {
        this.artists = list != null ? new ArrayList<ArtistInfo>(list) : null;
    }

    @Override
    public void setPicture(String string) {
        this.picture = string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.artistName == null ? 0 : this.artistName.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LastFmSimilarArtists lastFmSimilarArtists = (LastFmSimilarArtists)object;
        return !(this.artistName == null ? lastFmSimilarArtists.artistName != null : !this.artistName.equals(lastFmSimilarArtists.artistName));
    }
}

