/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.tray;

import java.awt.AWTException;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import net.sourceforge.atunes.Constants;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.controls.ActionTrayIcon;
import net.sourceforge.atunes.gui.views.controls.JTrayIcon;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.ExitAction;
import net.sourceforge.atunes.kernel.actions.MuteAction;
import net.sourceforge.atunes.kernel.actions.OSDSettingAction;
import net.sourceforge.atunes.kernel.actions.PlayAction;
import net.sourceforge.atunes.kernel.actions.PlayNextAudioObjectAction;
import net.sourceforge.atunes.kernel.actions.PlayPreviousAudioObjectAction;
import net.sourceforge.atunes.kernel.actions.RepeatModeAction;
import net.sourceforge.atunes.kernel.actions.ShowAboutAction;
import net.sourceforge.atunes.kernel.actions.ShuffleModeAction;
import net.sourceforge.atunes.kernel.actions.StopCurrentAudioObjectAction;
import net.sourceforge.atunes.kernel.actions.ToggleWindowVisibilityAction;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public final class SystemTrayHandler
extends AbstractHandler {
    private static SystemTrayHandler instance = new SystemTrayHandler();
    private boolean trayInitialized;
    private boolean trayIconVisible;
    private boolean trayPlayerVisible;
    private SystemTray tray;
    private JTrayIcon trayIcon;
    private TrayIcon previousIcon;
    private TrayIcon playIcon;
    private TrayIcon stopIcon;
    private TrayIcon nextIcon;
    private JMenuItem playMenuItem;

    private SystemTrayHandler() {
    }

    @Override
    protected void initHandler() {
    }

    @Override
    public void applicationStarted() {
    }

    public static SystemTrayHandler getInstance() {
        return instance;
    }

    private JTrayIcon.JTrayIconPopupMenu fillMenu(JTrayIcon.JTrayIconPopupMenu jTrayIconPopupMenu) {
        jTrayIconPopupMenu.add(this.getPlayMenuItem());
        jTrayIconPopupMenu.add(this.getStopMenuItem());
        jTrayIconPopupMenu.add(this.getPreviousMenuItem());
        jTrayIconPopupMenu.add(this.getNextMenuItem());
        jTrayIconPopupMenu.add(new JSeparator());
        jTrayIconPopupMenu.add(this.getMuteCheckBoxMenuItem());
        jTrayIconPopupMenu.add(new JSeparator());
        jTrayIconPopupMenu.add(this.getShuffleCheckBoxMenuItem());
        jTrayIconPopupMenu.add(this.getRepeatCheckBoxMenuItem());
        jTrayIconPopupMenu.add(new JSeparator());
        jTrayIconPopupMenu.add(this.getShowOSDCheckBoxMenuItem());
        jTrayIconPopupMenu.add(new JSeparator());
        jTrayIconPopupMenu.add(this.getAboutMenuItem());
        jTrayIconPopupMenu.add(new JSeparator());
        jTrayIconPopupMenu.add(this.getExitMenuItem());
        GuiUtils.applyComponentOrientation(jTrayIconPopupMenu);
        return jTrayIconPopupMenu;
    }

    @Override
    public void applicationFinish() {
        this.setTrayIconVisible(false);
        this.setTrayPlayerVisible(false);
    }

    private void initSystemTray() {
        if (!this.trayInitialized && SystemTray.isSupported()) {
            this.tray = SystemTray.getSystemTray();
            this.trayInitialized = true;
        }
    }

    public void initTrayIcon() {
        this.initSystemTray();
        if (this.isTrayInitialized()) {
            this.trayIconVisible = true;
            this.addTrayIcon(this.getTrayIcon());
            GuiHandler.getInstance().setFrameDefaultCloseOperation(1);
        } else {
            SystemTrayHandler.getLogger().error("TRAY        ", "No system tray supported");
        }
    }

    public void initTrayPlayerIcons() {
        this.initSystemTray();
        if (this.isTrayInitialized()) {
            this.trayPlayerVisible = true;
            this.addTrayIcon(this.getPreviousTrayIcon());
            this.addTrayIcon(this.getStopTrayIcon());
            this.addTrayIcon(this.getPlayTrayIcon());
            this.addTrayIcon(this.getNextTrayIcon());
        } else {
            SystemTrayHandler.getLogger().error("TRAY        ", "No system tray supported");
        }
    }

    private void addTrayIcon(TrayIcon trayIcon) {
        try {
            this.tray.add(trayIcon);
        }
        catch (AWTException aWTException) {
            SystemTrayHandler.getLogger().error("TRAY        ", aWTException);
        }
    }

    public void setPlaying(boolean bl) {
        if (this.isTrayInitialized()) {
            if (bl) {
                this.getPlayMenuItem().setText(I18nUtils.getString("PAUSE"));
                this.getPlayMenuItem().setIcon(Images.getImage("pauseTrayMenu.png"));
                this.getPlayTrayIcon().setImage(Images.getImage(Images.PAUSE_TRAY).getImage());
            } else {
                this.getPlayMenuItem().setText(I18nUtils.getString("PLAY"));
                this.getPlayMenuItem().setIcon(Images.getImage("playTrayMenu.png"));
                this.getPlayTrayIcon().setImage(Images.getImage(Images.PLAY_TRAY).getImage());
            }
        }
    }

    private void setTrayIconVisible(boolean bl) {
        if (bl && !this.trayIconVisible) {
            this.initTrayIcon();
            if (this.isTrayInitialized()) {
                this.trayIconAdvice();
            }
        } else if (!bl && this.trayIconVisible && this.isTrayInitialized()) {
            this.tray.remove(this.getTrayIcon());
            GuiHandler.getInstance().setFrameDefaultCloseOperation(2);
            this.trayIconVisible = false;
        }
    }

    private void setTrayPlayerVisible(boolean bl) {
        if (bl && !this.trayPlayerVisible) {
            this.initTrayPlayerIcons();
        } else if (!bl && this.trayPlayerVisible && this.isTrayInitialized()) {
            this.tray.remove(this.getPreviousTrayIcon());
            this.tray.remove(this.getPlayTrayIcon());
            this.tray.remove(this.getStopTrayIcon());
            this.tray.remove(this.getNextTrayIcon());
            this.trayPlayerVisible = false;
        }
    }

    public void setTrayToolTip(String string) {
        if (this.isTrayInitialized()) {
            this.getTrayIcon().setToolTip(string);
        }
    }

    private void trayIconAdvice() {
        if (SystemProperties.OS != SystemProperties.OperatingSystem.LINUX && this.isTrayInitialized()) {
            this.getTrayIcon().displayMessage("aTunes", I18nUtils.getString("TRAY_ICON_MESSAGE"), TrayIcon.MessageType.INFO);
        }
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
        this.setTrayIconVisible(applicationState.isShowSystemTray());
        this.setTrayPlayerVisible(applicationState.isShowTrayPlayer());
    }

    private JMenuItem getPlayMenuItem() {
        if (this.playMenuItem == null) {
            this.playMenuItem = new JMenuItem(Actions.getAction(PlayAction.class));
            this.playMenuItem.setIcon(Images.getImage("playTrayMenu.png"));
        }
        return this.playMenuItem;
    }

    private JMenuItem getStopMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(Actions.getAction(StopCurrentAudioObjectAction.class));
        jMenuItem.setText(I18nUtils.getString("STOP"));
        jMenuItem.setIcon(Images.getImage("stopTrayMenu.png"));
        return jMenuItem;
    }

    private JMenuItem getPreviousMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(Actions.getAction(PlayPreviousAudioObjectAction.class));
        jMenuItem.setText(I18nUtils.getString("PREVIOUS"));
        jMenuItem.setIcon(Images.getImage("previousTrayMenu.png"));
        return jMenuItem;
    }

    private JMenuItem getNextMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(Actions.getAction(PlayNextAudioObjectAction.class));
        jMenuItem.setText(I18nUtils.getString("NEXT"));
        jMenuItem.setIcon(Images.getImage("nextTrayMenu.png"));
        return jMenuItem;
    }

    private JCheckBoxMenuItem getMuteCheckBoxMenuItem() {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(Actions.getAction(MuteAction.class));
        jCheckBoxMenuItem.setText(I18nUtils.getString("MUTE"));
        jCheckBoxMenuItem.setIcon(Images.getImage("volume-mute-tray-menu.png"));
        return jCheckBoxMenuItem;
    }

    private JCheckBoxMenuItem getShuffleCheckBoxMenuItem() {
        return new JCheckBoxMenuItem(Actions.getAction(ShuffleModeAction.class));
    }

    private JCheckBoxMenuItem getRepeatCheckBoxMenuItem() {
        return new JCheckBoxMenuItem(Actions.getAction(RepeatModeAction.class));
    }

    private JCheckBoxMenuItem getShowOSDCheckBoxMenuItem() {
        return new JCheckBoxMenuItem(Actions.getAction(OSDSettingAction.class));
    }

    private JMenuItem getAboutMenuItem() {
        return new JMenuItem(Actions.getAction(ShowAboutAction.class));
    }

    private JMenuItem getExitMenuItem() {
        return new JMenuItem(Actions.getAction(ExitAction.class));
    }

    private JTrayIcon getTrayIcon() {
        if (this.trayIcon == null) {
            this.trayIcon = new JTrayIcon(Images.getImage("logo24x24.png").getImage(), SystemProperties.OS == SystemProperties.OperatingSystem.LINUX, Actions.getAction(ToggleWindowVisibilityAction.class));
            this.trayIcon.setToolTip(StringUtils.getString("aTunes", " ", Constants.VERSION.toShortString()));
            this.trayIcon.setJTrayIconJPopupMenu(this.fillMenu(this.trayIcon.new JTrayIcon.JTrayIconPopupMenu()));
            this.trayIcon.setImageAutoSize(true);
        }
        return this.trayIcon;
    }

    private TrayIcon getNextTrayIcon() {
        if (this.nextIcon == null) {
            this.nextIcon = new ActionTrayIcon(Images.getImage(Images.NEXT_TRAY).getImage(), Actions.getAction(PlayNextAudioObjectAction.class));
            this.nextIcon.setImageAutoSize(true);
        }
        return this.nextIcon;
    }

    private TrayIcon getStopTrayIcon() {
        if (this.stopIcon == null) {
            this.stopIcon = new ActionTrayIcon(Images.getImage(Images.STOP_TRAY).getImage(), Actions.getAction(StopCurrentAudioObjectAction.class));
            this.stopIcon.setImageAutoSize(true);
        }
        return this.stopIcon;
    }

    private TrayIcon getPlayTrayIcon() {
        if (this.playIcon == null) {
            this.playIcon = new ActionTrayIcon(Images.getImage(Images.PLAY_TRAY).getImage(), Actions.getAction(PlayAction.class));
            this.playIcon.setImageAutoSize(true);
        }
        return this.playIcon;
    }

    private TrayIcon getPreviousTrayIcon() {
        this.previousIcon = new ActionTrayIcon(Images.getImage(Images.PREVIOUS_TRAY).getImage(), Actions.getAction(PlayPreviousAudioObjectAction.class));
        this.previousIcon.setImageAutoSize(true);
        return this.previousIcon;
    }

    protected boolean isTrayInitialized() {
        return this.trayInitialized;
    }
}

