/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.tags.writer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.AbstractChangeTagProcess;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.TagModifier;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;

public class EditTitlesProcess
extends AbstractChangeTagProcess {
    private Map<AudioFile, String> filesAndTitles;

    public EditTitlesProcess(List<AudioFile> list) {
        super(list);
    }

    @Override
    protected void retrieveInformationBeforeChangeTags() {
        super.retrieveInformationBeforeChangeTags();
        if (this.filesAndTitles == null) {
            this.filesAndTitles = this.getTitlesForFiles(this.getFilesToChange());
        }
    }

    @Override
    protected void changeTag(AudioFile audioFile) {
        String string = this.filesAndTitles.get(audioFile);
        TagModifier.setTitles(audioFile, string);
    }

    public void setFilesAndTitles(Map<AudioFile, String> map) {
        this.filesAndTitles = map;
    }

    public Map<AudioFile, String> getTitlesForFiles(List<AudioFile> list) {
        HashMap<AudioFile, String> hashMap = new HashMap<AudioFile, String>();
        for (AudioFile audioFile : list) {
            String string = LastFmService.getInstance().getTitleForFile(audioFile);
            if (string == null) continue;
            hashMap.put(audioFile, string);
        }
        return hashMap;
    }
}

