/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.data;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.modules.repository.ImageCache;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.Format;
import net.sourceforge.atunes.kernel.modules.repository.data.Genre;
import net.sourceforge.atunes.kernel.modules.repository.tags.reader.TagDetector;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.AbstractTag;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.DefaultTag;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.EditTagInfo;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.GenericImageSize;
import net.sourceforge.atunes.model.ImageSize;
import net.sourceforge.atunes.utils.AudioFilePictureUtils;
import org.commonjukebox.plugins.model.PluginApi;

@PluginApi
public final class AudioFile
implements AudioObject,
Serializable,
Comparable<AudioFile> {
    private static final long serialVersionUID = -1139001443603556703L;
    private static ImageCache imageCache = new ImageCache();
    private AbstractTag tag;
    private List<File> externalPictures;
    private int duration;
    private long bitrate;
    private int frequency;
    private long readTime;
    private int stars;
    private File file;

    public AudioFile(File file) {
        this.readFile(file);
    }

    public AudioFile(String string) {
        this.readFile(new File(string));
    }

    private void readFile(File file) {
        this.file = file;
        if (!AudioFile.isValidAudioFile(file, Format.APE, Format.MPC)) {
            this.readInformation(true);
        }
        this.readTime = System.currentTimeMillis();
    }

    public static List<AudioFile> getAudioFiles(List<AudioObject> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>();
        for (AudioObject audioObject : list) {
            if (!(audioObject instanceof AudioFile)) continue;
            arrayList.add((AudioFile)audioObject);
        }
        return arrayList;
    }

    public static List<AudioObject> getAudioObjects(List<AudioFile> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return new ArrayList<AudioObject>(list);
    }

    public static AbstractTag getNewTag(AudioFile audioFile, EditTagInfo editTagInfo) {
        return new DefaultTag().getTagFromProperties(editTagInfo, audioFile.getTag());
    }

    public static boolean isValidAudioFile(File file) {
        return !file.isDirectory() && AudioFile.isValidAudioFile(file, Format.MP3, Format.OGG, Format.MP4_1, Format.MP4_2, Format.WAV, Format.WMA, Format.FLAC, Format.REAL_1, Format.REAL_2, Format.APE, Format.MPC);
    }

    public static boolean isValidAudioFile(File file, Format ... formatArray) {
        String string = file.getAbsolutePath().toLowerCase();
        for (Format format : formatArray) {
            if (!string.endsWith(format.getExtension())) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidAudioFile(String string) {
        File file = new File(string);
        return file.exists() && AudioFile.isValidAudioFile(file);
    }

    public void addExternalPicture(File file) {
        if (this.externalPictures == null) {
            this.externalPictures = new ArrayList<File>();
        }
        if (!this.externalPictures.contains(file)) {
            this.externalPictures.add(0, file);
        }
    }

    private void deleteTags() {
        this.tag = null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AudioFile)) {
            return false;
        }
        return ((AudioFile)object).getUrl().equals(this.getUrl());
    }

    @Override
    public String getAlbum() {
        String string = this.tag != null && this.tag.getAlbum() != null && !this.tag.getAlbum().isEmpty() ? this.tag.getAlbum() : Album.getUnknownAlbum();
        return string;
    }

    @Override
    public String getAlbumArtist() {
        String string = this.tag != null && this.tag.getAlbumArtist() != null ? this.tag.getAlbumArtist() : "";
        return string;
    }

    @Override
    public String getAlbumArtistOrArtist() {
        return this.getAlbumArtist().isEmpty() ? this.getArtist() : this.getAlbumArtist();
    }

    @Override
    public String getArtist() {
        String string = this.tag != null && this.tag.getArtist() != null && !this.tag.getArtist().isEmpty() ? this.tag.getArtist() : Artist.getUnknownArtist();
        return string;
    }

    @Override
    public long getBitrate() {
        return this.bitrate;
    }

    @Override
    public String getComposer() {
        String string = this.tag != null && this.tag.getComposer() != null ? this.tag.getComposer() : "";
        return string;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    public List<File> getExternalPictures() {
        return this.externalPictures;
    }

    public int getExternalPicturesCount() {
        return this.externalPictures != null ? this.externalPictures.size() : 0;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public int getFrequency() {
        return this.frequency;
    }

    @Override
    public String getGenre() {
        if (this.tag != null && this.tag.getGenre() != null && !this.tag.getGenre().isEmpty()) {
            return this.tag.getGenre();
        }
        return Genre.getUnknownGenre();
    }

    @Override
    public String getLyrics() {
        String string = this.tag != null && this.tag.getLyrics() != null ? this.tag.getLyrics() : "";
        return string;
    }

    @Override
    public String getComment() {
        if (this.tag != null && this.tag.getComment() != null) {
            return this.tag.getComment();
        }
        return "";
    }

    public String getNameWithoutExtension() {
        if (this.file == null) {
            return null;
        }
        if (this.file.getName().indexOf(46) != -1) {
            return this.file.getName().substring(0, this.file.getName().lastIndexOf(46));
        }
        return this.file.getName();
    }

    @Override
    public int getStars() {
        return this.stars;
    }

    public AbstractTag getTag() {
        return this.tag;
    }

    @Override
    public String getTitle() {
        String string = this.tag != null && this.tag.getTitle() != null ? this.tag.getTitle() : "";
        return string;
    }

    @Override
    public String getTitleOrFileName() {
        String string = this.tag != null && this.tag.getTitle() != null && !this.tag.getTitle().isEmpty() ? this.tag.getTitle() : this.getNameWithoutExtension();
        return string;
    }

    @Override
    public int getTrackNumber() {
        if (this.tag != null) {
            if (this.tag instanceof DefaultTag) {
                return ((DefaultTag)this.tag).getTrackNumber() > 0 ? ((DefaultTag)this.tag).getTrackNumber() : 0;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public String getUrl() {
        if (this.file == null) {
            return null;
        }
        return this.file.getAbsolutePath();
    }

    @Override
    public String getYear() {
        if (this.tag != null && this.tag.getYear() > 0) {
            return Integer.toString(this.tag.getYear());
        }
        return "";
    }

    @Override
    public Date getDate() {
        if (this.tag != null) {
            return this.tag.getDate();
        }
        return null;
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }

    public final boolean hasInternalPicture() {
        return this.tag != null && this.tag.hasInternalImage();
    }

    public final boolean supportsInternalPicture() {
        return AudioFile.isValidAudioFile(this.getFile(), Format.FLAC, Format.MP3, Format.MP4_1, Format.MP4_2, Format.OGG, Format.WMA);
    }

    private void readInformation(boolean bl) {
        TagDetector.readInformation(this, bl);
    }

    public boolean isUpToDate() {
        if (this.file == null) {
            return false;
        }
        return this.readTime > this.file.lastModified();
    }

    public void refreshTag() {
        this.deleteTags();
        this.readInformation(false);
        this.readTime = System.currentTimeMillis();
    }

    public void setExternalPictures(List<File> list) {
        this.externalPictures = list;
    }

    public void setFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.readFile(file);
    }

    @Override
    public void setStars(int n) {
        this.stars = n;
    }

    public void setTag(AbstractTag abstractTag) {
        this.tag = abstractTag;
    }

    public void setWritable() {
        if (!this.file.canWrite()) {
            this.file.setWritable(true);
        }
        if (!this.file.getParentFile().canWrite()) {
            this.file.getParentFile().setWritable(true);
        }
    }

    public String toString() {
        return this.file.getName();
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public int compareTo(AudioFile audioFile) {
        if (this.file == null || audioFile.getFile() == null) {
            return 0;
        }
        return this.file.compareTo(audioFile.getFile());
    }

    @Override
    public int getDiscNumber() {
        if (this.tag != null && this.tag.getDiscNumber() >= 1) {
            return this.tag.getDiscNumber();
        }
        return 0;
    }

    public static List<AudioFile> filterRepeatedSongs(List<AudioFile> list) {
        ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>(list);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (AudioFile audioFile : list) {
            Integer n = (!audioFile.getAlbumArtist().trim().equals("") ? audioFile.getAlbumArtist() : audioFile.getArtist()).hashCode() * audioFile.getTitle().hashCode();
            if (hashSet.contains(n)) {
                arrayList.remove(audioFile);
                continue;
            }
            hashSet.add(n);
        }
        return arrayList;
    }

    public static List<AudioFile> filterRepeatedSongsAndAlbums(List<AudioFile> list) {
        ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>(list);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (AudioFile audioFile : list) {
            Integer n = (!audioFile.getAlbumArtist().trim().equals("") ? audioFile.getAlbumArtist() : audioFile.getArtist()).hashCode() * audioFile.getAlbum().hashCode() * audioFile.getTitle().hashCode();
            if (hashSet.contains(n)) {
                arrayList.remove(audioFile);
                continue;
            }
            hashSet.add(n);
        }
        return arrayList;
    }

    @Override
    public ImageIcon getImage(ImageSize imageSize) {
        ImageIcon imageIcon = null;
        imageIcon = imageCache.retrieveImage(this, imageSize);
        if (imageIcon == null) {
            imageIcon = AudioFilePictureUtils.getInsidePicture(this, imageSize.getSize(), imageSize.getSize());
            if (imageIcon == null) {
                imageIcon = AudioFilePictureUtils.getExternalPicture(this, imageSize.getSize(), imageSize.getSize());
            }
        } else {
            return imageIcon;
        }
        if (imageIcon != null) {
            imageCache.storeImage(this, imageSize, imageIcon);
        }
        return imageIcon;
    }

    @Override
    public ImageIcon getGenericImage(GenericImageSize genericImageSize) {
        switch (genericImageSize) {
            case SMALL: {
                return Images.getImage("audioFile_little.png");
            }
            case MEDIUM: {
                return Images.getImage("audioFile.png");
            }
            case BIG: {
                return Images.getImage("audioFile_big.png");
            }
        }
        throw new IllegalArgumentException("unknown image size");
    }

    public static ImageCache getImageCache() {
        return imageCache;
    }

    public void setDuration(int n) {
        this.duration = n;
    }

    public void setBitrate(long l) {
        this.bitrate = l;
    }

    public void setFrequency(int n) {
        this.frequency = n;
    }
}

