/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.radio;

import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.dialogs.ExtendedToolTip;
import net.sourceforge.atunes.kernel.modules.proxy.Proxy;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.GenericImageSize;
import net.sourceforge.atunes.model.ImageSize;
import net.sourceforge.atunes.model.TreeObject;
import net.sourceforge.atunes.utils.NetworkUtils;
import org.commonjukebox.plugins.model.PluginApi;

@PluginApi
public final class Radio
implements AudioObject,
Serializable,
TreeObject,
Comparable<Radio> {
    private static final long serialVersionUID = 3295941106814718559L;
    private static final String[] PLAYLISTS = new String[]{"m3u", "pls", "asx", "wax", "b4s", "kpl", "wvx", "ram", "rm", "smil"};
    private static Comparator<Radio> comparator = new Comparator<Radio>(){

        @Override
        public int compare(Radio radio, Radio radio2) {
            return radio.getName().compareToIgnoreCase(radio2.getName());
        }
    };
    private String name;
    private String url;
    private String label;
    private String genre;
    private boolean isRemoved;
    private transient String artist;
    private transient String title;
    private transient boolean songInfoAvailable;
    private long bitrate;
    private int frequency;

    public Radio(String string, String string2, String string3) {
        this.name = string;
        this.url = string2;
        this.label = string3;
    }

    public static Comparator<Radio> getComparator() {
        return comparator;
    }

    public static List<Radio> getRadios(List<AudioObject> list) {
        ArrayList<Radio> arrayList = new ArrayList<Radio>();
        for (AudioObject audioObject : list) {
            if (!(audioObject instanceof Radio)) continue;
            arrayList.add((Radio)audioObject);
        }
        return arrayList;
    }

    public void deleteSongInfo() {
        this.artist = null;
        this.title = null;
        this.songInfoAvailable = false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Radio)) {
            return false;
        }
        return (this.name + this.url).equals(((Radio)object).getName() + ((Radio)object).getUrl());
    }

    @Override
    public String getAlbum() {
        return "";
    }

    @Override
    public String getAlbumArtist() {
        return "";
    }

    @Override
    public String getAlbumArtistOrArtist() {
        return this.getAlbumArtist().isEmpty() ? this.getArtist() : this.getAlbumArtist();
    }

    @Override
    public String getArtist() {
        return this.artist == null ? "" : this.artist;
    }

    @Override
    public List<AudioObject> getAudioObjects() {
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        arrayList.add(this);
        return arrayList;
    }

    @Override
    public long getBitrate() {
        return this.bitrate;
    }

    @Override
    public String getComposer() {
        return "";
    }

    @Override
    public int getDuration() {
        return 0;
    }

    @Override
    public int getFrequency() {
        return this.frequency;
    }

    @Override
    public String getGenre() {
        if (this.genre != null) {
            return this.genre;
        }
        return "";
    }

    @Override
    public String getLyrics() {
        return "";
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getStars() {
        return 0;
    }

    @Override
    public String getTitle() {
        return this.title == null ? this.getName() : this.title;
    }

    @Override
    public String getTitleOrFileName() {
        return this.getTitle();
    }

    @Override
    public int getTrackNumber() {
        return 0;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getYear() {
        return "";
    }

    @Override
    public Date getDate() {
        return null;
    }

    public int hashCode() {
        return (this.name + this.url).hashCode();
    }

    public boolean hasPlaylistUrl(Proxy proxy) {
        for (String string : PLAYLISTS) {
            if (!this.url.trim().toLowerCase().endsWith(string)) continue;
            return true;
        }
        try {
            String string = NetworkUtils.readURL(NetworkUtils.getConnection(this.url, proxy), 100);
            for (String string2 : PLAYLISTS) {
                if (!string.trim().toLowerCase().contains(string2)) continue;
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return false;
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    public boolean isSongInfoAvailable() {
        return this.songInfoAvailable;
    }

    public void setArtist(String string) {
        this.artist = string;
    }

    public void setBitrate(long l) {
        this.bitrate = l;
    }

    public void setFrequency(int n) {
        this.frequency = n;
    }

    public void setGenre(String string) {
        this.genre = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setRemoved(boolean bl) {
        this.isRemoved = bl;
    }

    public void setSongInfoAvailable(boolean bl) {
        this.songInfoAvailable = bl;
    }

    @Override
    public void setStars(int n) {
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String toString() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    @Override
    public boolean isSeekable() {
        return false;
    }

    @Override
    public int compareTo(Radio radio) {
        return this.name.compareTo(radio.getName());
    }

    @Override
    public int getDiscNumber() {
        return 0;
    }

    @Override
    public String getComment() {
        return "";
    }

    @Override
    public String getToolTip() {
        return this.name;
    }

    @Override
    public boolean isExtendedToolTipSupported() {
        return false;
    }

    @Override
    public void setExtendedToolTip(ExtendedToolTip extendedToolTip) {
    }

    @Override
    public ImageIcon getExtendedToolTipImage() {
        return null;
    }

    @Override
    public boolean isExtendedToolTipImageSupported() {
        return false;
    }

    @Override
    public ImageIcon getImage(ImageSize imageSize) {
        return null;
    }

    @Override
    public ImageIcon getGenericImage(GenericImageSize genericImageSize) {
        switch (genericImageSize) {
            case SMALL: {
                return Images.getImage("radio_little.png");
            }
            case MEDIUM: {
                return Images.getImage("radio.png");
            }
            case BIG: {
                return Images.getImage("radio_big.png");
            }
        }
        throw new IllegalArgumentException("unknown image size");
    }
}

