/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.process;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.gui.views.dialogs.ProgressDialog;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.process.ProcessListener;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.I18nUtils;

public abstract class AbstractProcess {
    private Logger logger;
    private volatile List<ProcessListener> listeners;
    private volatile boolean canceled = false;
    private volatile long processSize;
    private ProgressDialog progressDialog;
    private Component owner;

    public final void addProcessListener(ProcessListener processListener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<ProcessListener>();
        }
        this.listeners.add(processListener);
    }

    public final void removeProcessListener(ProcessListener processListener) {
        if (this.listeners != null) {
            this.listeners.remove(processListener);
        }
    }

    protected String getProgressDialogInformation() {
        return I18nUtils.getString("PLEASE_WAIT");
    }

    protected final void cancelProcess() {
        this.canceled = true;
    }

    public final void execute() {
        this.addDebugLog(this.getClass().getName());
        this.processSize = this.getProcessSize();
        this.getProgressDialog().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AbstractProcess.this.cancelProcess();
            }
        });
        Thread thread = new Thread(new ProcessRunnable());
        thread.start();
    }

    protected final void addInfoLog(Object object) {
        this.getLogger().info("PROCESS     ", object);
    }

    protected final void addDebugLog() {
        this.getLogger().debug("PROCESS     ");
    }

    protected final void addDebugLog(Object ... objectArray) {
        this.getLogger().debug("PROCESS     ", objectArray);
    }

    protected final void addErrorLog(Object object) {
        this.getLogger().error("PROCESS     ", object);
    }

    protected ProgressDialog getProgressDialog() {
        if (this.progressDialog == null) {
            this.progressDialog = GuiHandler.getInstance().getNewProgressDialog(this.getProgressDialogTitle(), this.owner);
            this.progressDialog.setInfoText(this.getProgressDialogInformation());
            this.progressDialog.setCurrentProgress(0L);
            this.progressDialog.setProgressBarValue(0);
            this.progressDialog.addCancelButtonActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractProcess.this.cancelProcess();
                    AbstractProcess.this.progressDialog.disableCancelButton();
                }
            });
        }
        return this.progressDialog;
    }

    final void showProgressDialog() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AbstractProcess.this.getProgressDialog().setTotalProgress(AbstractProcess.this.processSize);
                    AbstractProcess.this.getProgressDialog().setVisible(true);
                }
            });
        }
        catch (Exception exception) {
            this.getLogger().error("PROCESS     ", exception);
        }
    }

    final void hideProgressDialog() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AbstractProcess.this.getProgressDialog().setVisible(false);
                }
            });
        }
        catch (Exception exception) {
            this.getLogger().error("PROCESS     ", exception);
        }
    }

    protected final void setCurrentProgress(final long l) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AbstractProcess.this.getProgressDialog().setCurrentProgress(l);
                    AbstractProcess.this.getProgressDialog().setProgressBarValue((int)((double)l * 100.0 / (double)AbstractProcess.this.processSize));
                }
            });
        }
        catch (Exception exception) {
            this.getLogger().error("PROCESS     ", exception);
        }
    }

    protected void setOwner(Component component) {
        this.owner = component;
    }

    protected abstract String getProgressDialogTitle();

    protected abstract boolean runProcess();

    protected abstract void runCancel();

    protected abstract long getProcessSize();

    protected boolean isCanceled() {
        return this.canceled;
    }

    protected Component getOwner() {
        return this.owner;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    private final class ProcessRunnable
    implements Runnable {
        private ProcessRunnable() {
        }

        @Override
        public void run() {
            AbstractProcess.this.showProgressDialog();
            boolean bl = AbstractProcess.this.runProcess();
            AbstractProcess.this.hideProgressDialog();
            if (AbstractProcess.this.canceled) {
                AbstractProcess.this.runCancel();
            }
            if (AbstractProcess.this.listeners != null && !AbstractProcess.this.listeners.isEmpty()) {
                for (ProcessListener processListener : AbstractProcess.this.listeners) {
                    if (AbstractProcess.this.canceled) {
                        processListener.processCanceled();
                        continue;
                    }
                    processListener.processFinished(bl);
                }
            }
        }
    }
}

