/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.podcast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.navigator.PodcastNavigationView;
import net.sourceforge.atunes.kernel.modules.podcast.FeedType;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeed;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.proxy.Proxy;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.DateUtils;
import net.sourceforge.atunes.utils.NetworkUtils;
import net.sourceforge.atunes.utils.StringUtils;
import net.sourceforge.atunes.utils.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PodcastFeedEntryRetriever
implements Runnable {
    private Logger logger;
    private List<PodcastFeed> podcastFeeds;

    public PodcastFeedEntryRetriever(List<PodcastFeed> list) {
        this.podcastFeeds = list;
    }

    public List<PodcastFeed> retrievePodcastFeedEntries(boolean bl, Proxy proxy) {
        ArrayList<PodcastFeed> arrayList = new ArrayList<PodcastFeed>();
        for (PodcastFeed podcastFeed : this.podcastFeeds) {
            try {
                Document document = XMLUtils.getXMLDocument(NetworkUtils.readURL(NetworkUtils.getConnection(podcastFeed.getUrl(), proxy)));
                if (document == null) continue;
                FeedType feedType = this.determineFeedType(document);
                if (feedType == null) {
                    this.getLogger().info("PODCAST     ", podcastFeed + " is not a rss or atom feed");
                    continue;
                }
                podcastFeed.setFeedType(feedType);
                if (podcastFeed.isRetrieveNameFromFeed()) {
                    this.retrieveNameFromFeed(podcastFeed, document);
                }
                NodeList nodeList = XMLUtils.evaluateXPathExpressionAndReturnNodeList(feedType.getEntryXPath(), document);
                ArrayList<PodcastFeedEntry> arrayList2 = new ArrayList<PodcastFeedEntry>();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String string;
                    Node node;
                    Node node2;
                    Node node3;
                    Node node4;
                    String string2 = "";
                    String string3 = "";
                    String string4 = "";
                    String string5 = "";
                    Date date = null;
                    int n = 0;
                    Node node5 = XMLUtils.evaluateXPathExpressionAndReturnNode(feedType.getTypeXPath(), nodeList.item(i));
                    if (node5 == null || !node5.getTextContent().matches(".*audio.*")) {
                        this.getLogger().info("PODCAST     ", StringUtils.getString("podcast feed entry is not from type audio: ", node5 != null ? node5.getTextContent() : "no type node"));
                        continue;
                    }
                    Node node6 = XMLUtils.evaluateXPathExpressionAndReturnNode(feedType.getTitleXPath(), nodeList.item(i));
                    if (node6 != null) {
                        string2 = node6.getTextContent();
                    }
                    if ((node4 = XMLUtils.evaluateXPathExpressionAndReturnNode(feedType.getUrlXPath(), nodeList.item(i))) == null) continue;
                    string3 = node4.getTextContent();
                    Node node7 = XMLUtils.evaluateXPathExpressionAndReturnNode(feedType.getAuthorXPath(), nodeList.item(i));
                    if (node7 != null) {
                        string4 = node7.getTextContent();
                    }
                    if ((node3 = XMLUtils.evaluateXPathExpressionAndReturnNode(feedType.getDescriptionXPath(), nodeList.item(i))) != null) {
                        string5 = node3.getTextContent();
                        string5 = string5.replaceAll("\\<.*?\\>", "");
                    }
                    if ((node2 = XMLUtils.evaluateXPathExpressionAndReturnNode(feedType.getDateXPath(), nodeList.item(i))) != null && (date = DateUtils.parseRFC822Date(node2.getTextContent())) == null) {
                        date = DateUtils.parseRFC3339Date(node2.getTextContent());
                    }
                    if ((node = XMLUtils.evaluateXPathExpressionAndReturnNode(feedType.getDurationXPath(), nodeList.item(i))) != null && (string = node.getTextContent()) != null) {
                        String[] stringArray = string.split(":");
                        try {
                            for (int j = stringArray.length - 1; j >= 0; --j) {
                                n += Integer.parseInt(stringArray[j]) * (int)Math.pow(60.0, stringArray.length - 1 - j);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            n = 0;
                            this.getLogger().info("PODCAST     ", "could not extract podcast feed entry duration");
                        }
                    }
                    arrayList2.add(new PodcastFeedEntry(string2, string4, string3, string5, date, n, podcastFeed));
                }
                podcastFeed.addEntries(arrayList2, bl);
                if (!podcastFeed.hasNewEntries()) continue;
                arrayList.add(podcastFeed);
            }
            catch (DOMException dOMException) {
                this.getLogger().error("PODCAST     ", StringUtils.getString("Could not retrieve podcast feed entries from ", podcastFeed, ": ", dOMException));
            }
            catch (IOException iOException) {
                this.getLogger().error("PODCAST     ", StringUtils.getString("Could not retrieve podcast feed entries from ", podcastFeed, ": ", iOException));
            }
        }
        return arrayList;
    }

    private void refreshView() {
        SwingUtilities.invokeLater(new RefreshViewRunnable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMessage(final List<PodcastFeed> list) {
        List<PodcastFeed> list2 = this.podcastFeeds;
        synchronized (list2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (PodcastFeed podcastFeed : list) {
                        if (!PodcastFeedEntryRetriever.this.podcastFeeds.contains(podcastFeed)) continue;
                        for (PodcastFeed podcastFeed2 : PodcastFeedEntryRetriever.this.podcastFeeds) {
                            podcastFeed2.markEntriesAsNotNew();
                        }
                        GuiHandler.getInstance().showNewPodcastFeedEntriesInfo();
                        break;
                    }
                }
            });
        }
    }

    private FeedType determineFeedType(Document document) {
        if (XMLUtils.evaluateXPathExpressionAndReturnNode("/rss", document) != null) {
            return FeedType.RSS;
        }
        if (XMLUtils.evaluateXPathExpressionAndReturnNode("/feed", document) != null) {
            return FeedType.ATOM;
        }
        return null;
    }

    private void retrieveNameFromFeed(PodcastFeed podcastFeed, Document document) {
        Node node = XMLUtils.evaluateXPathExpressionAndReturnNode(podcastFeed.getFeedType().getNameXPath(), document);
        if (node != null) {
            String string = node.getTextContent();
            podcastFeed.setName(string == null ? "" : string);
        }
    }

    @Override
    public void run() {
        try {
            boolean bl = ApplicationState.getInstance().isRemovePodcastFeedEntriesRemovedFromPodcastFeed();
            Proxy proxy = Proxy.getProxy(ApplicationState.getInstance().getProxy());
            List<PodcastFeed> list = this.retrievePodcastFeedEntries(bl, proxy);
            this.showMessage(list);
            this.refreshView();
        }
        catch (IOException iOException) {
            this.getLogger().error("PODCAST     ", StringUtils.getString("Could not retrieve podcast feed entries : ", iOException));
        }
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    private static class RefreshViewRunnable
    implements Runnable {
        private RefreshViewRunnable() {
        }

        @Override
        public void run() {
            NavigationHandler.getInstance().refreshView(PodcastNavigationView.class);
            new Logger().info("PODCAST     ", "Podcast feed entries retrieval done");
        }
    }
}

