/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.podcast;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedHandler;
import net.sourceforge.atunes.misc.log.Logger;

public class PodcastFeedEntryDownloadChecker
implements Runnable {
    private Logger logger;

    @Override
    public void run() {
        HashMap hashMap = new HashMap();
        try {
            SwingUtilities.invokeAndWait(new GetPodcastFeedEntriesFilesRunnable(hashMap));
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.getLogger().error("PODCAST     ", invocationTargetException);
        }
        HashMap hashMap2 = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            hashMap2.put(entry.getKey(), ((File)entry.getValue()).exists() && !PodcastFeedHandler.getInstance().isDownloading((PodcastFeedEntry)entry.getKey()));
        }
        SwingUtilities.invokeLater(new SetDownloadedRunnable(hashMap2));
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    private static final class GetPodcastFeedEntriesFilesRunnable
    implements Runnable {
        private final Map<PodcastFeedEntry, File> files;

        private GetPodcastFeedEntriesFilesRunnable(Map<PodcastFeedEntry, File> map) {
            this.files = map;
        }

        @Override
        public void run() {
            for (PodcastFeedEntry podcastFeedEntry : PodcastFeedHandler.getInstance().getPodcastFeedEntries()) {
                File file = new File(PodcastFeedHandler.getInstance().getDownloadPath(podcastFeedEntry));
                this.files.put(podcastFeedEntry, file);
            }
        }
    }

    private static final class SetDownloadedRunnable
    implements Runnable {
        private final Map<PodcastFeedEntry, Boolean> downloaded;

        private SetDownloadedRunnable(Map<PodcastFeedEntry, Boolean> map) {
            this.downloaded = map;
        }

        @Override
        public void run() {
            for (Map.Entry<PodcastFeedEntry, Boolean> entry : this.downloaded.entrySet()) {
                entry.getKey().setDownloaded(entry.getValue());
            }
            GuiHandler.getInstance().getNavigationTablePanel().getNavigationTable().repaint();
        }
    }
}

