/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.podcast;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;
import net.sourceforge.atunes.gui.views.dialogs.ExtendedToolTip;
import net.sourceforge.atunes.kernel.modules.podcast.FeedType;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.TreeObject;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class PodcastFeed
implements TreeObject,
Serializable {
    private static final long serialVersionUID = 1416452911272034086L;
    private static Comparator<PodcastFeed> comparator = new Comparator<PodcastFeed>(){

        @Override
        public int compare(PodcastFeed podcastFeed, PodcastFeed podcastFeed2) {
            return podcastFeed.name.compareToIgnoreCase(podcastFeed2.name);
        }
    };
    private transient Logger logger;
    private String name;
    private String url;
    private FeedType feedType;
    private List<PodcastFeedEntry> podcastFeedEntries;
    private boolean hasNewEntries;
    private boolean retrieveNameFromFeed;

    public PodcastFeed(String string, String string2) {
        this.name = string;
        this.url = string2;
        this.podcastFeedEntries = new ArrayList<PodcastFeedEntry>();
    }

    public static Comparator<PodcastFeed> getComparator() {
        return comparator;
    }

    public synchronized boolean equals(Object object) {
        if (!(object instanceof PodcastFeed)) {
            return false;
        }
        return (this.name + this.url).equals(((PodcastFeed)object).getName() + ((PodcastFeed)object).getUrl());
    }

    @Override
    public synchronized List<AudioObject> getAudioObjects() {
        return new ArrayList<AudioObject>(this.podcastFeedEntries);
    }

    public FeedType getFeedType() {
        return this.feedType;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized List<PodcastFeedEntry> getPodcastFeedEntries() {
        return new ArrayList<PodcastFeedEntry>(this.podcastFeedEntries);
    }

    public String getUrl() {
        return this.url;
    }

    public synchronized int hashCode() {
        return (this.name + this.url).hashCode();
    }

    public boolean hasNewEntries() {
        return this.hasNewEntries;
    }

    public boolean isRetrieveNameFromFeed() {
        return this.retrieveNameFromFeed;
    }

    public synchronized void markEntriesAsListened() {
        for (PodcastFeedEntry podcastFeedEntry : this.podcastFeedEntries) {
            podcastFeedEntry.setListened(true);
        }
    }

    public void markEntriesAsNotNew() {
        this.hasNewEntries = false;
    }

    public synchronized void addEntries(List<? extends PodcastFeedEntry> list, boolean bl) {
        this.getLogger().debug("PODCAST     ");
        ArrayList<? extends PodcastFeedEntry> arrayList = new ArrayList<PodcastFeedEntry>(list);
        ArrayList<PodcastFeedEntry> arrayList2 = new ArrayList<PodcastFeedEntry>(this.podcastFeedEntries);
        arrayList2.removeAll(arrayList);
        if (bl) {
            this.podcastFeedEntries.removeAll(arrayList2);
        }
        for (PodcastFeedEntry podcastFeedEntry : arrayList2) {
            podcastFeedEntry.setOld(true);
        }
        arrayList.removeAll(this.podcastFeedEntries);
        if (!arrayList.isEmpty()) {
            this.hasNewEntries = true;
        }
        for (PodcastFeedEntry podcastFeedEntry : arrayList) {
            podcastFeedEntry.setOld(false);
        }
        this.podcastFeedEntries.addAll(0, arrayList);
    }

    public synchronized void removeEntry(PodcastFeedEntry podcastFeedEntry) {
        this.podcastFeedEntries.remove(podcastFeedEntry);
    }

    public void setFeedType(FeedType feedType) {
        this.feedType = feedType;
    }

    public synchronized void setName(String string) {
        this.name = string;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setRetrieveNameFromFeed(boolean bl) {
        this.retrieveNameFromFeed = bl;
    }

    public synchronized int getNewEntriesCount() {
        int n = 0;
        for (PodcastFeedEntry podcastFeedEntry : this.podcastFeedEntries) {
            if (podcastFeedEntry.isListened()) continue;
            ++n;
        }
        return n;
    }

    public synchronized String toString() {
        return this.name;
    }

    @Override
    public synchronized String getToolTip() {
        return this.name;
    }

    @Override
    public boolean isExtendedToolTipSupported() {
        return true;
    }

    @Override
    public synchronized void setExtendedToolTip(ExtendedToolTip extendedToolTip) {
        extendedToolTip.setLine1(this.name);
        extendedToolTip.setLine2(StringUtils.getString(I18nUtils.getString("PODCAST_ENTRIES"), ": ", this.podcastFeedEntries.size()));
        extendedToolTip.setLine3(StringUtils.getString(I18nUtils.getString("NEW_PODCAST_ENTRIES_TOOLTIP"), ": ", this.getNewEntriesCount()));
    }

    @Override
    public ImageIcon getExtendedToolTipImage() {
        return null;
    }

    @Override
    public boolean isExtendedToolTipImageSupported() {
        return false;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

