/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.plugins;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.sourceforge.atunes.gui.lookandfeel.AbstractLookAndFeel;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.Kernel;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.kernel.modules.columns.ColumnSets;
import net.sourceforge.atunes.kernel.modules.context.AbstractContextPanel;
import net.sourceforge.atunes.kernel.modules.context.ContextHandler;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.navigator.AbstractNavigationView;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.player.PlaybackStateListener;
import net.sourceforge.atunes.kernel.modules.player.PlayerHandler;
import net.sourceforge.atunes.kernel.modules.plugins.AbstractGeneralPurposePlugin;
import net.sourceforge.atunes.kernel.modules.plugins.GeneralPurposePluginsHandler;
import net.sourceforge.atunes.kernel.modules.plugins.PluginType;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.misc.Timer;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.apache.commons.io.FileUtils;
import org.commonjukebox.plugins.PluginSystemLogger;
import org.commonjukebox.plugins.PluginsFactory;
import org.commonjukebox.plugins.exceptions.InvalidPluginConfigurationException;
import org.commonjukebox.plugins.exceptions.PluginSystemException;
import org.commonjukebox.plugins.model.Plugin;
import org.commonjukebox.plugins.model.PluginConfiguration;
import org.commonjukebox.plugins.model.PluginFolder;
import org.commonjukebox.plugins.model.PluginInfo;
import org.commonjukebox.plugins.model.PluginListener;

public class PluginsHandler
extends AbstractHandler
implements PluginListener {
    private static PluginsHandler instance;
    private PluginsFactory factory;
    private static Set<PluginType> pluginTypes;
    private Map<PluginFolder, PluginSystemException> problemsLoadingPlugins;

    public static PluginsHandler getInstance() {
        if (instance == null) {
            instance = new PluginsHandler();
        }
        return instance;
    }

    private void initPlugins() {
        try {
            this.factory = new PluginsFactory();
            PluginSystemLogger.addHandler((Handler)new PluginsLoggerHandler());
            PluginSystemLogger.setLevel((Level)Level.ALL);
            this.factory.setPluginsRepository(PluginsHandler.getUserPluginsFolder());
            this.factory.setTemporalPluginRepository(PluginsHandler.getTemporalPluginsFolder());
        }
        catch (PluginSystemException pluginSystemException) {
            PluginsHandler.getLogger().error("PLUGINS     ", (Object)pluginSystemException);
        }
        catch (IOException iOException) {
            PluginsHandler.getLogger().error("PLUGINS     ", iOException);
        }
    }

    @Override
    public void applicationFinish() {
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
    }

    @Override
    protected void initHandler() {
        this.initPlugins();
    }

    @Override
    public void applicationStarted() {
        this.addPluginListeners();
        Timer timer = new Timer();
        timer.start();
        try {
            this.problemsLoadingPlugins = this.factory.start(this.getPluginClassNames(), true, "net.sourceforge.atunes");
        }
        catch (PluginSystemException pluginSystemException) {
            PluginsHandler.getLogger().error("PLUGINS     ", (Object)pluginSystemException);
        }
        PluginsHandler.getLogger().info("PLUGINS     ", StringUtils.getString("Found ", this.factory.getPlugins().size(), " plugins (", timer.stop(), " seconds)"));
        PluginsHandler.getLogger().info("PLUGINS     ", StringUtils.getString("Problems loading ", this.problemsLoadingPlugins != null ? this.problemsLoadingPlugins.size() : 0, " plugins"));
        if (this.problemsLoadingPlugins != null) {
            for (PluginFolder pluginFolder : this.problemsLoadingPlugins.keySet()) {
                GuiHandler.getInstance().showExceptionDialog(pluginFolder.getName(), I18nUtils.getString("PLUGIN_LOAD_ERROR"), (Exception)((Object)this.problemsLoadingPlugins.get(pluginFolder)));
                if (GuiHandler.getInstance().showConfirmationDialog(I18nUtils.getString("PLUGIN_LOAD_ERROR_REMOVE_CONFIRMATION")) != 0) continue;
                try {
                    FileUtils.deleteDirectory((File)pluginFolder);
                }
                catch (IOException iOException) {
                    GuiHandler.getInstance().showExceptionDialog(pluginFolder.getName(), I18nUtils.getString("PLUGIN_UNINSTALLATION_ERROR"), iOException);
                }
            }
        }
    }

    private Set<PluginType> getPluginTypes() {
        if (pluginTypes == null) {
            pluginTypes = new HashSet<PluginType>();
            pluginTypes.add(new PluginType(PlaybackStateListener.class.getName(), PlayerHandler.getInstance(), false));
            pluginTypes.add(new PluginType(AbstractColumn.class.getName(), ColumnSets.getInstance(), false));
            pluginTypes.add(new PluginType(AbstractNavigationView.class.getName(), NavigationHandler.getInstance(), false));
            pluginTypes.add(new PluginType(AbstractContextPanel.class.getName(), ContextHandler.getInstance(), false));
            pluginTypes.add(new PluginType(AbstractLookAndFeel.class.getName(), LookAndFeelSelector.getInstance(), false));
            pluginTypes.add(new PluginType(AbstractGeneralPurposePlugin.class.getName(), GeneralPurposePluginsHandler.getInstance(), false));
        }
        return pluginTypes;
    }

    private Set<String> getPluginClassNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (PluginType pluginType : this.getPluginTypes()) {
            hashSet.add(pluginType.getClassType());
        }
        return hashSet;
    }

    private void addPluginListeners() {
        for (PluginType pluginType : this.getPluginTypes()) {
            this.factory.addPluginListener(pluginType.getClassType(), (PluginListener)this);
            this.factory.addPluginListener(pluginType.getClassType(), pluginType.getListener());
        }
    }

    public List<PluginInfo> getAvailablePlugins() {
        return this.factory.getPlugins();
    }

    private static String getUserPluginsFolder() {
        String string = SystemProperties.getUserConfigFolder(Kernel.isDebug());
        String string2 = StringUtils.getString(string, SystemProperties.FILE_SEPARATOR, "plugins");
        File file = new File(string2);
        if (!file.exists() && !file.mkdir()) {
            return string;
        }
        return string2;
    }

    private static String getTemporalPluginsFolder() throws IOException {
        String string = StringUtils.getString(SystemProperties.getTempFolder(), SystemProperties.FILE_SEPARATOR, "plugins");
        File file = new File(string);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException(StringUtils.getString("Can't create temporal plugins folder: ", string));
        }
        return string;
    }

    public Map<PluginFolder, PluginSystemException> installPlugin(File file) throws PluginSystemException {
        try {
            return this.factory.installPlugin(file);
        }
        catch (PluginSystemException pluginSystemException) {
            PluginsHandler.getLogger().error("PLUGINS     ", (Object)pluginSystemException);
            throw pluginSystemException;
        }
    }

    public Map<PluginFolder, PluginSystemException> uninstallPlugin(PluginInfo pluginInfo) throws IOException, PluginSystemException {
        PluginFolder pluginFolder = pluginInfo.getPluginFolder();
        if (pluginFolder.getParent().equals(new File(PluginsHandler.getUserPluginsFolder()).getAbsolutePath())) {
            try {
                return this.factory.uninstallPlugin(pluginInfo);
            }
            catch (PluginSystemException pluginSystemException) {
                PluginsHandler.getLogger().error("PLUGINS     ", (Object)pluginSystemException);
                throw pluginSystemException;
            }
        }
        return new HashMap<PluginFolder, PluginSystemException>();
    }

    public void setPluginActive(PluginInfo pluginInfo, boolean bl) {
        try {
            if (bl) {
                PluginsHandler.getInstance().activatePlugin(pluginInfo);
            } else {
                PluginsHandler.getInstance().deactivatePlugin(pluginInfo);
            }
        }
        catch (PluginSystemException pluginSystemException) {
            PluginsHandler.getLogger().error("PLUGINS     ", (Object)pluginSystemException);
        }
    }

    public void pluginActivated(PluginInfo pluginInfo) {
        PluginsHandler.getLogger().info("PLUGINS     ", StringUtils.getString("Plugin activated: ", pluginInfo.getName(), " (", pluginInfo.getClassName(), ")"));
    }

    public void pluginDeactivated(PluginInfo pluginInfo, Collection<Plugin> collection) {
        PluginsHandler.getLogger().info("PLUGINS     ", StringUtils.getString("Plugin deactivated: ", pluginInfo.getName(), " (", pluginInfo.getClassName(), ")"));
    }

    public boolean pluginNeedsRestart(PluginInfo pluginInfo) {
        for (PluginType pluginType : this.getPluginTypes()) {
            if (!pluginInfo.getPluginType().equals(pluginType.getClassType())) continue;
            return pluginType.isApplicationNeedsRestart();
        }
        return false;
    }

    public Plugin getNewInstance(PluginInfo pluginInfo) throws PluginSystemException {
        return this.factory.getNewInstance(pluginInfo);
    }

    public void activatePlugin(PluginInfo pluginInfo) throws PluginSystemException {
        this.factory.activatePlugin(pluginInfo);
    }

    public void deactivatePlugin(PluginInfo pluginInfo) throws PluginSystemException {
        this.factory.deactivatePlugin(pluginInfo);
    }

    public void validateConfiguration(PluginInfo pluginInfo, PluginConfiguration pluginConfiguration) throws InvalidPluginConfigurationException {
        this.factory.validateConfiguration(pluginInfo, pluginConfiguration);
    }

    public void setConfiguration(PluginInfo pluginInfo, PluginConfiguration pluginConfiguration) throws PluginSystemException {
        this.factory.setConfiguration(pluginInfo, pluginConfiguration);
    }

    public PluginConfiguration getConfiguration(PluginInfo pluginInfo) throws PluginSystemException {
        return this.factory.getConfiguration(pluginInfo);
    }

    private static class PluginsLoggerHandler
    extends Handler {
        private PluginsLoggerHandler() {
        }

        @Override
        public void publish(LogRecord logRecord) {
            if (logRecord.getLevel().equals(Level.SEVERE)) {
                PluginsHandler.getLogger().error("PLUGINS     ", logRecord.getMessage());
            } else {
                PluginsHandler.getLogger().info("PLUGINS     ", logRecord.getMessage());
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

